// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The configuration for an Amazon S3 access point or multi-region access point for the bucket. You can propose up to 10 access points or multi-region access points per bucket. If the proposed Amazon S3 access point configuration is for an existing bucket, the access preview uses the proposed access point configuration in place of the existing access points. To propose an access point without a policy, you can provide an empty string as the access point policy. For more information, see [Creating access points](https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html). For more information about access point policy limits, see [Access points restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html).
 */
public class S3AccessPointConfiguration private constructor(builder: Builder) {
    /**
     * The access point or multi-region access point policy.
     */
    public val accessPointPolicy: kotlin.String? = builder.accessPointPolicy
    /**
     * The proposed `Internet` and `VpcConfiguration` to apply to this Amazon S3 access point. `VpcConfiguration` does not apply to multi-region access points. If the access preview is for a new resource and neither is specified, the access preview uses `Internet` for the network origin. If the access preview is for an existing resource and neither is specified, the access preview uses the exiting network origin.
     */
    public val networkOrigin: aws.sdk.kotlin.services.accessanalyzer.model.NetworkOriginConfiguration? = builder.networkOrigin
    /**
     * The proposed `S3PublicAccessBlock` configuration to apply to this Amazon S3 access point or multi-region access point.
     */
    public val publicAccessBlock: aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration? = builder.publicAccessBlock

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.S3AccessPointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3AccessPointConfiguration(")
        append("accessPointPolicy=$accessPointPolicy,")
        append("networkOrigin=$networkOrigin,")
        append("publicAccessBlock=$publicAccessBlock")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointPolicy?.hashCode() ?: 0
        result = 31 * result + (networkOrigin?.hashCode() ?: 0)
        result = 31 * result + (publicAccessBlock?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3AccessPointConfiguration

        if (accessPointPolicy != other.accessPointPolicy) return false
        if (networkOrigin != other.networkOrigin) return false
        if (publicAccessBlock != other.publicAccessBlock) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.S3AccessPointConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The access point or multi-region access point policy.
         */
        public var accessPointPolicy: kotlin.String? = null
        /**
         * The proposed `Internet` and `VpcConfiguration` to apply to this Amazon S3 access point. `VpcConfiguration` does not apply to multi-region access points. If the access preview is for a new resource and neither is specified, the access preview uses `Internet` for the network origin. If the access preview is for an existing resource and neither is specified, the access preview uses the exiting network origin.
         */
        public var networkOrigin: aws.sdk.kotlin.services.accessanalyzer.model.NetworkOriginConfiguration? = null
        /**
         * The proposed `S3PublicAccessBlock` configuration to apply to this Amazon S3 access point or multi-region access point.
         */
        public var publicAccessBlock: aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.S3AccessPointConfiguration) : this() {
            this.accessPointPolicy = x.accessPointPolicy
            this.networkOrigin = x.networkOrigin
            this.publicAccessBlock = x.publicAccessBlock
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.S3AccessPointConfiguration = S3AccessPointConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration] inside the given [block]
         */
        public fun publicAccessBlock(block: aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration.Builder.() -> kotlin.Unit) {
            this.publicAccessBlock = aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
