// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the policy generation status and properties.
 */
public class PolicyGeneration private constructor(builder: Builder) {
    /**
     * A timestamp of when the policy generation was completed.
     */
    public val completedOn: aws.smithy.kotlin.runtime.time.Instant? = builder.completedOn
    /**
     * The `JobId` that is returned by the `StartPolicyGeneration` operation. The `JobId` can be used with `GetGeneratedPolicy` to retrieve the generated policies or used with `CancelPolicyGeneration` to cancel the policy generation request.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * The ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    public val principalArn: kotlin.String = requireNotNull(builder.principalArn) { "A non-null value must be provided for principalArn" }
    /**
     * A timestamp of when the policy generation started.
     */
    public val startedOn: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startedOn) { "A non-null value must be provided for startedOn" }
    /**
     * The status of the policy generation request.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.JobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.PolicyGeneration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyGeneration(")
        append("completedOn=$completedOn,")
        append("jobId=$jobId,")
        append("principalArn=$principalArn,")
        append("startedOn=$startedOn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completedOn?.hashCode() ?: 0
        result = 31 * result + (jobId.hashCode())
        result = 31 * result + (principalArn.hashCode())
        result = 31 * result + (startedOn.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyGeneration

        if (completedOn != other.completedOn) return false
        if (jobId != other.jobId) return false
        if (principalArn != other.principalArn) return false
        if (startedOn != other.startedOn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.PolicyGeneration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp of when the policy generation was completed.
         */
        public var completedOn: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The `JobId` that is returned by the `StartPolicyGeneration` operation. The `JobId` can be used with `GetGeneratedPolicy` to retrieve the generated policies or used with `CancelPolicyGeneration` to cancel the policy generation request.
         */
        public var jobId: kotlin.String? = null
        /**
         * The ARN of the IAM entity (user or role) for which you are generating a policy.
         */
        public var principalArn: kotlin.String? = null
        /**
         * A timestamp of when the policy generation started.
         */
        public var startedOn: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the policy generation request.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.PolicyGeneration) : this() {
            this.completedOn = x.completedOn
            this.jobId = x.jobId
            this.principalArn = x.principalArn
            this.startedOn = x.startedOn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.PolicyGeneration = PolicyGeneration(this)

        internal fun correctErrors(): Builder {
            if (jobId == null) jobId = ""
            if (principalArn == null) principalArn = ""
            if (startedOn == null) startedOn = Instant.fromEpochSeconds(0)
            if (status == null) status = JobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
