// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Retrieves a list of findings generated by the specified analyzer.
 */
public class ListFindingsRequest private constructor(builder: Builder) {
    /**
     * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) to retrieve findings from.
     */
    public val analyzerArn: kotlin.String = requireNotNull(builder.analyzerArn) { "A non-null value must be provided for analyzerArn" }
    /**
     * A filter to match for the findings to return.
     */
    public val filter: Map<String, Criterion>? = builder.filter
    /**
     * The maximum number of results to return in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The sort order for the findings returned.
     */
    public val sort: aws.sdk.kotlin.services.accessanalyzer.model.SortCriteria? = builder.sort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFindingsRequest(")
        append("analyzerArn=$analyzerArn,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sort=$sort")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn.hashCode()
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFindingsRequest

        if (analyzerArn != other.analyzerArn) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sort != other.sort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) to retrieve findings from.
         */
        public var analyzerArn: kotlin.String? = null
        /**
         * A filter to match for the findings to return.
         */
        public var filter: Map<String, Criterion>? = null
        /**
         * The maximum number of results to return in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token used for pagination of results returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The sort order for the findings returned.
         */
        public var sort: aws.sdk.kotlin.services.accessanalyzer.model.SortCriteria? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sort = x.sort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsRequest = ListFindingsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.SortCriteria] inside the given [block]
         */
        public fun sort(block: aws.sdk.kotlin.services.accessanalyzer.model.SortCriteria.Builder.() -> kotlin.Unit) {
            this.sort = aws.sdk.kotlin.services.accessanalyzer.model.SortCriteria.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (analyzerArn == null) analyzerArn = ""
            return this
        }
    }
}
