// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Retrieves a list of archive rules created for the specified analyzer.
 */
public class ListArchiveRulesRequest private constructor(builder: Builder) {
    /**
     * The name of the analyzer to retrieve rules from.
     */
    public val analyzerName: kotlin.String = requireNotNull(builder.analyzerName) { "A non-null value must be provided for analyzerName" }
    /**
     * The maximum number of results to return in the request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.ListArchiveRulesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListArchiveRulesRequest(")
        append("analyzerName=$analyzerName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerName.hashCode()
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListArchiveRulesRequest

        if (analyzerName != other.analyzerName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.ListArchiveRulesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the analyzer to retrieve rules from.
         */
        public var analyzerName: kotlin.String? = null
        /**
         * The maximum number of results to return in the request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token used for pagination of results returned.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.ListArchiveRulesRequest) : this() {
            this.analyzerName = x.analyzerName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.ListArchiveRulesRequest = ListArchiveRulesRequest(this)

        internal fun correctErrors(): Builder {
            if (analyzerName == null) analyzerName = ""
            return this
        }
    }
}
