// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Retrieves a list of resources that have been analyzed.
 */
public class ListAnalyzedResourcesRequest private constructor(builder: Builder) {
    /**
     * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) to retrieve a list of analyzed resources from.
     */
    public val analyzerArn: kotlin.String = requireNotNull(builder.analyzerArn) { "A non-null value must be provided for analyzerArn" }
    /**
     * The maximum number of results to return in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of resource.
     */
    public val resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAnalyzedResourcesRequest(")
        append("analyzerArn=$analyzerArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn.hashCode()
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAnalyzedResourcesRequest

        if (analyzerArn != other.analyzerArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) to retrieve a list of analyzed resources from.
         */
        public var analyzerArn: kotlin.String? = null
        /**
         * The maximum number of results to return in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token used for pagination of results returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The type of resource.
         */
        public var resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesRequest = ListAnalyzedResourcesRequest(this)

        internal fun correctErrors(): Builder {
            if (analyzerArn == null) analyzerArn = ""
            return this
        }
    }
}
