// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Proposed access control configuration for a KMS key. You can propose a configuration for a new KMS key or an existing KMS key that you own by specifying the key policy and KMS grant configuration. If the configuration is for an existing key and you do not specify the key policy, the access preview uses the existing policy for the key. If the access preview is for a new resource and you do not specify the key policy, then the access preview uses the default key policy. The proposed key policy cannot be an empty string. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default). For more information about key policy limits, see [Resource quotas](https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html).
 */
public class KmsKeyConfiguration private constructor(builder: Builder) {
    /**
     * A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an existing key, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the key.
     */
    public val grants: List<KmsGrantConfiguration>? = builder.grants
    /**
     * Resource policy configuration for the KMS key. The only valid value for the name of the key policy is `default`. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).
     */
    public val keyPolicies: Map<String, String>? = builder.keyPolicies

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.KmsKeyConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KmsKeyConfiguration(")
        append("grants=$grants,")
        append("keyPolicies=$keyPolicies")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = grants?.hashCode() ?: 0
        result = 31 * result + (keyPolicies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KmsKeyConfiguration

        if (grants != other.grants) return false
        if (keyPolicies != other.keyPolicies) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.KmsKeyConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an existing key, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the key.
         */
        public var grants: List<KmsGrantConfiguration>? = null
        /**
         * Resource policy configuration for the KMS key. The only valid value for the name of the key policy is `default`. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).
         */
        public var keyPolicies: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.KmsKeyConfiguration) : this() {
            this.grants = x.grants
            this.keyPolicies = x.keyPolicies
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.KmsKeyConfiguration = KmsKeyConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
