// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Use this structure to propose allowing [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) in the grant only when the operation request includes the specified [encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context). You can specify only one type of encryption context. An empty map is treated as not specified. For more information, see [GrantConstraints](https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html).
 */
public class KmsGrantConstraints private constructor(builder: Builder) {
    /**
     * A list of key-value pairs that must match the encryption context in the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.
     */
    public val encryptionContextEquals: Map<String, String>? = builder.encryptionContextEquals
    /**
     * A list of key-value pairs that must be included in the encryption context of the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.
     */
    public val encryptionContextSubset: Map<String, String>? = builder.encryptionContextSubset

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KmsGrantConstraints(")
        append("encryptionContextEquals=$encryptionContextEquals,")
        append("encryptionContextSubset=$encryptionContextSubset")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionContextEquals?.hashCode() ?: 0
        result = 31 * result + (encryptionContextSubset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KmsGrantConstraints

        if (encryptionContextEquals != other.encryptionContextEquals) return false
        if (encryptionContextSubset != other.encryptionContextSubset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of key-value pairs that must match the encryption context in the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.
         */
        public var encryptionContextEquals: Map<String, String>? = null
        /**
         * A list of key-value pairs that must be included in the encryption context of the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.
         */
        public var encryptionContextSubset: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints) : this() {
            this.encryptionContextEquals = x.encryptionContextEquals
            this.encryptionContextSubset = x.encryptionContextSubset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints = KmsGrantConstraints(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
