// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * A proposed grant configuration for a KMS key. For more information, see [CreateGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html).
 */
public class KmsGrantConfiguration private constructor(builder: Builder) {
    /**
     * Use this structure to propose allowing [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) in the grant only when the operation request includes the specified [encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
     */
    public val constraints: aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints? = builder.constraints
    /**
     * The principal that is given permission to perform the operations that the grant permits.
     */
    public val granteePrincipal: kotlin.String = requireNotNull(builder.granteePrincipal) { "A non-null value must be provided for granteePrincipal" }
    /**
     * The Amazon Web Services account under which the grant was issued. The account is used to propose KMS grants issued by accounts other than the owner of the key.
     */
    public val issuingAccount: kotlin.String = requireNotNull(builder.issuingAccount) { "A non-null value must be provided for issuingAccount" }
    /**
     * A list of operations that the grant permits.
     */
    public val operations: List<KmsGrantOperation> = requireNotNull(builder.operations) { "A non-null value must be provided for operations" }
    /**
     * The principal that is given permission to retire the grant by using [RetireGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html) operation.
     */
    public val retiringPrincipal: kotlin.String? = builder.retiringPrincipal

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KmsGrantConfiguration(")
        append("constraints=$constraints,")
        append("granteePrincipal=$granteePrincipal,")
        append("issuingAccount=$issuingAccount,")
        append("operations=$operations,")
        append("retiringPrincipal=$retiringPrincipal")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = constraints?.hashCode() ?: 0
        result = 31 * result + (granteePrincipal.hashCode())
        result = 31 * result + (issuingAccount.hashCode())
        result = 31 * result + (operations.hashCode())
        result = 31 * result + (retiringPrincipal?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KmsGrantConfiguration

        if (constraints != other.constraints) return false
        if (granteePrincipal != other.granteePrincipal) return false
        if (issuingAccount != other.issuingAccount) return false
        if (operations != other.operations) return false
        if (retiringPrincipal != other.retiringPrincipal) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use this structure to propose allowing [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) in the grant only when the operation request includes the specified [encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
         */
        public var constraints: aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints? = null
        /**
         * The principal that is given permission to perform the operations that the grant permits.
         */
        public var granteePrincipal: kotlin.String? = null
        /**
         * The Amazon Web Services account under which the grant was issued. The account is used to propose KMS grants issued by accounts other than the owner of the key.
         */
        public var issuingAccount: kotlin.String? = null
        /**
         * A list of operations that the grant permits.
         */
        public var operations: List<KmsGrantOperation>? = null
        /**
         * The principal that is given permission to retire the grant by using [RetireGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html) operation.
         */
        public var retiringPrincipal: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConfiguration) : this() {
            this.constraints = x.constraints
            this.granteePrincipal = x.granteePrincipal
            this.issuingAccount = x.issuingAccount
            this.operations = x.operations
            this.retiringPrincipal = x.retiringPrincipal
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConfiguration = KmsGrantConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints] inside the given [block]
         */
        public fun constraints(block: aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints.Builder.() -> kotlin.Unit) {
            this.constraints = aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (granteePrincipal == null) granteePrincipal = ""
            if (issuingAccount == null) issuingAccount = ""
            if (operations == null) operations = emptyList()
            return this
        }
    }
}
