// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the policy generation request.
 */
public class JobDetails private constructor(builder: Builder) {
    /**
     * A timestamp of when the job was completed.
     */
    public val completedOn: aws.smithy.kotlin.runtime.time.Instant? = builder.completedOn
    /**
     * The job error for the policy generation request.
     */
    public val jobError: aws.sdk.kotlin.services.accessanalyzer.model.JobError? = builder.jobError
    /**
     * The `JobId` that is returned by the `StartPolicyGeneration` operation. The `JobId` can be used with `GetGeneratedPolicy` to retrieve the generated policies or used with `CancelPolicyGeneration` to cancel the policy generation request.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * A timestamp of when the job was started.
     */
    public val startedOn: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startedOn) { "A non-null value must be provided for startedOn" }
    /**
     * The status of the job request.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.JobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.JobDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobDetails(")
        append("completedOn=$completedOn,")
        append("jobError=$jobError,")
        append("jobId=$jobId,")
        append("startedOn=$startedOn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completedOn?.hashCode() ?: 0
        result = 31 * result + (jobError?.hashCode() ?: 0)
        result = 31 * result + (jobId.hashCode())
        result = 31 * result + (startedOn.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobDetails

        if (completedOn != other.completedOn) return false
        if (jobError != other.jobError) return false
        if (jobId != other.jobId) return false
        if (startedOn != other.startedOn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.JobDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp of when the job was completed.
         */
        public var completedOn: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The job error for the policy generation request.
         */
        public var jobError: aws.sdk.kotlin.services.accessanalyzer.model.JobError? = null
        /**
         * The `JobId` that is returned by the `StartPolicyGeneration` operation. The `JobId` can be used with `GetGeneratedPolicy` to retrieve the generated policies or used with `CancelPolicyGeneration` to cancel the policy generation request.
         */
        public var jobId: kotlin.String? = null
        /**
         * A timestamp of when the job was started.
         */
        public var startedOn: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the job request.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.JobDetails) : this() {
            this.completedOn = x.completedOn
            this.jobError = x.jobError
            this.jobId = x.jobId
            this.startedOn = x.startedOn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.JobDetails = JobDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.JobError] inside the given [block]
         */
        public fun jobError(block: aws.sdk.kotlin.services.accessanalyzer.model.JobError.Builder.() -> kotlin.Unit) {
            this.jobError = aws.sdk.kotlin.services.accessanalyzer.model.JobError.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (jobId == null) jobId = ""
            if (startedOn == null) startedOn = Instant.fromEpochSeconds(0)
            if (status == null) status = JobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
