// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



public class GetGeneratedPolicyRequest private constructor(builder: Builder) {
    /**
     * The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.
     *
     * For example, in the resource section of a policy, you can receive a placeholder such as `"Resource":"arn:aws:s3:::${BucketName}"` instead of `"*"`.
     */
    public val includeResourcePlaceholders: kotlin.Boolean? = builder.includeResourcePlaceholders
    /**
     * The level of detail that you want to generate. You can specify whether to generate service-level policies.
     *
     * IAM Access Analyzer uses `iam:servicelastaccessed` to identify services that have been used recently to create this service-level template.
     */
    public val includeServiceLevelTemplate: kotlin.Boolean? = builder.includeServiceLevelTemplate
    /**
     * The `JobId` that is returned by the `StartPolicyGeneration` operation. The `JobId` can be used with `GetGeneratedPolicy` to retrieve the generated policies or used with `CancelPolicyGeneration` to cancel the policy generation request.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.GetGeneratedPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetGeneratedPolicyRequest(")
        append("includeResourcePlaceholders=$includeResourcePlaceholders,")
        append("includeServiceLevelTemplate=$includeServiceLevelTemplate,")
        append("jobId=$jobId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeResourcePlaceholders?.hashCode() ?: 0
        result = 31 * result + (includeServiceLevelTemplate?.hashCode() ?: 0)
        result = 31 * result + (jobId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetGeneratedPolicyRequest

        if (includeResourcePlaceholders != other.includeResourcePlaceholders) return false
        if (includeServiceLevelTemplate != other.includeServiceLevelTemplate) return false
        if (jobId != other.jobId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.GetGeneratedPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.
         *
         * For example, in the resource section of a policy, you can receive a placeholder such as `"Resource":"arn:aws:s3:::${BucketName}"` instead of `"*"`.
         */
        public var includeResourcePlaceholders: kotlin.Boolean? = null
        /**
         * The level of detail that you want to generate. You can specify whether to generate service-level policies.
         *
         * IAM Access Analyzer uses `iam:servicelastaccessed` to identify services that have been used recently to create this service-level template.
         */
        public var includeServiceLevelTemplate: kotlin.Boolean? = null
        /**
         * The `JobId` that is returned by the `StartPolicyGeneration` operation. The `JobId` can be used with `GetGeneratedPolicy` to retrieve the generated policies or used with `CancelPolicyGeneration` to cancel the policy generation request.
         */
        public var jobId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.GetGeneratedPolicyRequest) : this() {
            this.includeResourcePlaceholders = x.includeResourcePlaceholders
            this.includeServiceLevelTemplate = x.includeServiceLevelTemplate
            this.jobId = x.jobId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.GetGeneratedPolicyRequest = GetGeneratedPolicyRequest(this)

        internal fun correctErrors(): Builder {
            if (jobId == null) jobId = ""
            return this
        }
    }
}
