// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetFindingV2Response private constructor(builder: Builder) {
    /**
     * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
     */
    public val analyzedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.analyzedAt) { "A non-null value must be provided for analyzedAt" }
    /**
     * The time at which the finding was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * An error.
     */
    public val error: kotlin.String? = builder.error
    /**
     * A localized message that explains the finding and provides guidance on how to address it.
     */
    public val findingDetails: List<FindingDetails> = requireNotNull(builder.findingDetails) { "A non-null value must be provided for findingDetails" }
    /**
     * The type of the finding. For external access analyzers, the type is `ExternalAccess`. For unused access analyzers, the type can be `UnusedIAMRole`, `UnusedIAMUserAccessKey`, `UnusedIAMUserPassword`, or `UnusedPermission`.
     */
    public val findingType: aws.sdk.kotlin.services.accessanalyzer.model.FindingType? = builder.findingType
    /**
     * The ID of the finding to retrieve.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * A token used for pagination of results returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The resource that generated the finding.
     */
    public val resource: kotlin.String? = builder.resource
    /**
     * Tye Amazon Web Services account ID that owns the resource.
     */
    public val resourceOwnerAccount: kotlin.String = requireNotNull(builder.resourceOwnerAccount) { "A non-null value must be provided for resourceOwnerAccount" }
    /**
     * The type of the resource identified in the finding.
     */
    public val resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * The status of the finding.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The time at which the finding was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Response = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetFindingV2Response(")
        append("analyzedAt=$analyzedAt,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("findingDetails=$findingDetails,")
        append("findingType=$findingType,")
        append("id=$id,")
        append("nextToken=$nextToken,")
        append("resource=$resource,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzedAt.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (findingDetails.hashCode())
        result = 31 * result + (findingType?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerAccount.hashCode())
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetFindingV2Response

        if (analyzedAt != other.analyzedAt) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (findingDetails != other.findingDetails) return false
        if (findingType != other.findingType) return false
        if (id != other.id) return false
        if (nextToken != other.nextToken) return false
        if (resource != other.resource) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Response = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
         */
        public var analyzedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the finding was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An error.
         */
        public var error: kotlin.String? = null
        /**
         * A localized message that explains the finding and provides guidance on how to address it.
         */
        public var findingDetails: List<FindingDetails>? = null
        /**
         * The type of the finding. For external access analyzers, the type is `ExternalAccess`. For unused access analyzers, the type can be `UnusedIAMRole`, `UnusedIAMUserAccessKey`, `UnusedIAMUserPassword`, or `UnusedPermission`.
         */
        public var findingType: aws.sdk.kotlin.services.accessanalyzer.model.FindingType? = null
        /**
         * The ID of the finding to retrieve.
         */
        public var id: kotlin.String? = null
        /**
         * A token used for pagination of results returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The resource that generated the finding.
         */
        public var resource: kotlin.String? = null
        /**
         * Tye Amazon Web Services account ID that owns the resource.
         */
        public var resourceOwnerAccount: kotlin.String? = null
        /**
         * The type of the resource identified in the finding.
         */
        public var resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType? = null
        /**
         * The status of the finding.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = null
        /**
         * The time at which the finding was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Response) : this() {
            this.analyzedAt = x.analyzedAt
            this.createdAt = x.createdAt
            this.error = x.error
            this.findingDetails = x.findingDetails
            this.findingType = x.findingType
            this.id = x.id
            this.nextToken = x.nextToken
            this.resource = x.resource
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Response = GetFindingV2Response(this)

        internal fun correctErrors(): Builder {
            if (analyzedAt == null) analyzedAt = Instant.fromEpochSeconds(0)
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (findingDetails == null) findingDetails = emptyList()
            if (id == null) id = ""
            if (resourceOwnerAccount == null) resourceOwnerAccount = ""
            if (resourceType == null) resourceType = ResourceType.SdkUnknown("no value provided")
            if (status == null) status = FindingStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
