// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a finding.
 */
public class FindingSummaryV2 private constructor(builder: Builder) {
    /**
     * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
     */
    public val analyzedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.analyzedAt) { "A non-null value must be provided for analyzedAt" }
    /**
     * The time at which the finding was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The error that resulted in an Error finding.
     */
    public val error: kotlin.String? = builder.error
    /**
     * The type of the external access or unused access finding.
     */
    public val findingType: aws.sdk.kotlin.services.accessanalyzer.model.FindingType? = builder.findingType
    /**
     * The ID of the finding.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The resource that the external principal has access to.
     */
    public val resource: kotlin.String? = builder.resource
    /**
     * The Amazon Web Services account ID that owns the resource.
     */
    public val resourceOwnerAccount: kotlin.String = requireNotNull(builder.resourceOwnerAccount) { "A non-null value must be provided for resourceOwnerAccount" }
    /**
     * The type of the resource that the external principal has access to.
     */
    public val resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * The status of the finding.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The time at which the finding was most recently updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.FindingSummaryV2 = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FindingSummaryV2(")
        append("analyzedAt=$analyzedAt,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("findingType=$findingType,")
        append("id=$id,")
        append("resource=$resource,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzedAt.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (findingType?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerAccount.hashCode())
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FindingSummaryV2

        if (analyzedAt != other.analyzedAt) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (findingType != other.findingType) return false
        if (id != other.id) return false
        if (resource != other.resource) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.FindingSummaryV2 = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
         */
        public var analyzedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the finding was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The error that resulted in an Error finding.
         */
        public var error: kotlin.String? = null
        /**
         * The type of the external access or unused access finding.
         */
        public var findingType: aws.sdk.kotlin.services.accessanalyzer.model.FindingType? = null
        /**
         * The ID of the finding.
         */
        public var id: kotlin.String? = null
        /**
         * The resource that the external principal has access to.
         */
        public var resource: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that owns the resource.
         */
        public var resourceOwnerAccount: kotlin.String? = null
        /**
         * The type of the resource that the external principal has access to.
         */
        public var resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType? = null
        /**
         * The status of the finding.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = null
        /**
         * The time at which the finding was most recently updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.FindingSummaryV2) : this() {
            this.analyzedAt = x.analyzedAt
            this.createdAt = x.createdAt
            this.error = x.error
            this.findingType = x.findingType
            this.id = x.id
            this.resource = x.resource
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.FindingSummaryV2 = FindingSummaryV2(this)

        internal fun correctErrors(): Builder {
            if (analyzedAt == null) analyzedAt = Instant.fromEpochSeconds(0)
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (resourceOwnerAccount == null) resourceOwnerAccount = ""
            if (resourceType == null) resourceType = ResourceType.SdkUnknown("no value provided")
            if (status == null) status = FindingStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
