// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a finding.
 */
public class Finding private constructor(builder: Builder) {
    /**
     * The action in the analyzed policy statement that an external principal has permission to use.
     */
    public val action: List<String>? = builder.action
    /**
     * The time at which the resource was analyzed.
     */
    public val analyzedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.analyzedAt) { "A non-null value must be provided for analyzedAt" }
    /**
     * The condition in the analyzed policy statement that resulted in a finding.
     */
    public val condition: Map<String, String> = requireNotNull(builder.condition) { "A non-null value must be provided for condition" }
    /**
     * The time at which the finding was generated.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * An error.
     */
    public val error: kotlin.String? = builder.error
    /**
     * The ID of the finding.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Indicates whether the policy that generated the finding allows public access to the resource.
     */
    public val isPublic: kotlin.Boolean? = builder.isPublic
    /**
     * The external principal that has access to a resource within the zone of trust.
     */
    public val principal: Map<String, String>? = builder.principal
    /**
     * The resource that an external principal has access to.
     */
    public val resource: kotlin.String? = builder.resource
    /**
     * The Amazon Web Services account ID that owns the resource.
     */
    public val resourceOwnerAccount: kotlin.String = requireNotNull(builder.resourceOwnerAccount) { "A non-null value must be provided for resourceOwnerAccount" }
    /**
     * The type of the resource identified in the finding.
     */
    public val resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
     */
    public val sources: List<FindingSource>? = builder.sources
    /**
     * The current status of the finding.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The time at which the finding was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.Finding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Finding(")
        append("action=$action,")
        append("analyzedAt=$analyzedAt,")
        append("condition=$condition,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("id=$id,")
        append("isPublic=$isPublic,")
        append("principal=$principal,")
        append("resource=$resource,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("sources=$sources,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (analyzedAt.hashCode())
        result = 31 * result + (condition.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (isPublic?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerAccount.hashCode())
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Finding

        if (action != other.action) return false
        if (analyzedAt != other.analyzedAt) return false
        if (condition != other.condition) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (id != other.id) return false
        if (isPublic != other.isPublic) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (sources != other.sources) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.Finding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action in the analyzed policy statement that an external principal has permission to use.
         */
        public var action: List<String>? = null
        /**
         * The time at which the resource was analyzed.
         */
        public var analyzedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The condition in the analyzed policy statement that resulted in a finding.
         */
        public var condition: Map<String, String>? = null
        /**
         * The time at which the finding was generated.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An error.
         */
        public var error: kotlin.String? = null
        /**
         * The ID of the finding.
         */
        public var id: kotlin.String? = null
        /**
         * Indicates whether the policy that generated the finding allows public access to the resource.
         */
        public var isPublic: kotlin.Boolean? = null
        /**
         * The external principal that has access to a resource within the zone of trust.
         */
        public var principal: Map<String, String>? = null
        /**
         * The resource that an external principal has access to.
         */
        public var resource: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that owns the resource.
         */
        public var resourceOwnerAccount: kotlin.String? = null
        /**
         * The type of the resource identified in the finding.
         */
        public var resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType? = null
        /**
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
         */
        public var sources: List<FindingSource>? = null
        /**
         * The current status of the finding.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = null
        /**
         * The time at which the finding was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.Finding) : this() {
            this.action = x.action
            this.analyzedAt = x.analyzedAt
            this.condition = x.condition
            this.createdAt = x.createdAt
            this.error = x.error
            this.id = x.id
            this.isPublic = x.isPublic
            this.principal = x.principal
            this.resource = x.resource
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.sources = x.sources
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.Finding = Finding(this)

        internal fun correctErrors(): Builder {
            if (analyzedAt == null) analyzedAt = Instant.fromEpochSeconds(0)
            if (condition == null) condition = emptyMap()
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (resourceOwnerAccount == null) resourceOwnerAccount = ""
            if (resourceType == null) resourceType = ResourceType.SdkUnknown("no value provided")
            if (status == null) status = FindingStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
