// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Contains information about an external access finding.
 */
public class ExternalAccessDetails private constructor(builder: Builder) {
    /**
     * The action in the analyzed policy statement that an external principal has permission to use.
     */
    public val action: List<String>? = builder.action
    /**
     * The condition in the analyzed policy statement that resulted in an external access finding.
     */
    public val condition: Map<String, String> = requireNotNull(builder.condition) { "A non-null value must be provided for condition" }
    /**
     * Specifies whether the external access finding is public.
     */
    public val isPublic: kotlin.Boolean? = builder.isPublic
    /**
     * The external principal that has access to a resource within the zone of trust.
     */
    public val principal: Map<String, String>? = builder.principal
    /**
     * The sources of the external access finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
     */
    public val sources: List<FindingSource>? = builder.sources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.ExternalAccessDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExternalAccessDetails(")
        append("action=$action,")
        append("condition=$condition,")
        append("isPublic=$isPublic,")
        append("principal=$principal,")
        append("sources=$sources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (condition.hashCode())
        result = 31 * result + (isPublic?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExternalAccessDetails

        if (action != other.action) return false
        if (condition != other.condition) return false
        if (isPublic != other.isPublic) return false
        if (principal != other.principal) return false
        if (sources != other.sources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.ExternalAccessDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action in the analyzed policy statement that an external principal has permission to use.
         */
        public var action: List<String>? = null
        /**
         * The condition in the analyzed policy statement that resulted in an external access finding.
         */
        public var condition: Map<String, String>? = null
        /**
         * Specifies whether the external access finding is public.
         */
        public var isPublic: kotlin.Boolean? = null
        /**
         * The external principal that has access to a resource within the zone of trust.
         */
        public var principal: Map<String, String>? = null
        /**
         * The sources of the external access finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
         */
        public var sources: List<FindingSource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.ExternalAccessDetails) : this() {
            this.action = x.action
            this.condition = x.condition
            this.isPublic = x.isPublic
            this.principal = x.principal
            this.sources = x.sources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.ExternalAccessDetails = ExternalAccessDetails(this)

        internal fun correctErrors(): Builder {
            if (condition == null) condition = emptyMap()
            return this
        }
    }
}
