// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The proposed access control configuration for an Amazon EFS file system. You can propose a configuration for a new Amazon EFS file system or an existing Amazon EFS file system that you own by specifying the Amazon EFS policy. For more information, see [Using file systems in Amazon EFS](https://docs.aws.amazon.com/efs/latest/ug/using-fs.html).
 * + If the configuration is for an existing Amazon EFS file system and you do not specify the Amazon EFS policy, then the access preview uses the existing Amazon EFS policy for the file system.
 * + If the access preview is for a new resource and you do not specify the policy, then the access preview assumes an Amazon EFS file system without a policy.
 * + To propose deletion of an existing Amazon EFS file system policy, you can specify an empty string for the Amazon EFS policy.
 */
public class EfsFileSystemConfiguration private constructor(builder: Builder) {
    /**
     * The JSON policy definition to apply to the Amazon EFS file system. For more information on the elements that make up a file system policy, see [Amazon EFS Resource-based policies](https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies).
     */
    public val fileSystemPolicy: kotlin.String? = builder.fileSystemPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.EfsFileSystemConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EfsFileSystemConfiguration(")
        append("fileSystemPolicy=$fileSystemPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemPolicy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EfsFileSystemConfiguration

        if (fileSystemPolicy != other.fileSystemPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.EfsFileSystemConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The JSON policy definition to apply to the Amazon EFS file system. For more information on the elements that make up a file system policy, see [Amazon EFS Resource-based policies](https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies).
         */
        public var fileSystemPolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.EfsFileSystemConfiguration) : this() {
            this.fileSystemPolicy = x.fileSystemPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.EfsFileSystemConfiguration = EfsFileSystemConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
