// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The proposed access control configuration for an Amazon ECR repository. You can propose a configuration for a new Amazon ECR repository or an existing Amazon ECR repository that you own by specifying the Amazon ECR policy. For more information, see [Repository](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_Repository.html).
 * + If the configuration is for an existing Amazon ECR repository and you do not specify the Amazon ECR policy, then the access preview uses the existing Amazon ECR policy for the repository.
 * + If the access preview is for a new resource and you do not specify the policy, then the access preview assumes an Amazon ECR repository without a policy.
 * + To propose deletion of an existing Amazon ECR repository policy, you can specify an empty string for the Amazon ECR policy.
 */
public class EcrRepositoryConfiguration private constructor(builder: Builder) {
    /**
     * The JSON repository policy text to apply to the Amazon ECR repository. For more information, see [Private repository policy examples](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html) in the *Amazon ECR User Guide*.
     */
    public val repositoryPolicy: kotlin.String? = builder.repositoryPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.EcrRepositoryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcrRepositoryConfiguration(")
        append("repositoryPolicy=$repositoryPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = repositoryPolicy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcrRepositoryConfiguration

        if (repositoryPolicy != other.repositoryPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.EcrRepositoryConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The JSON repository policy text to apply to the Amazon ECR repository. For more information, see [Private repository policy examples](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html) in the *Amazon ECR User Guide*.
         */
        public var repositoryPolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.EcrRepositoryConfiguration) : this() {
            this.repositoryPolicy = x.repositoryPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.EcrRepositoryConfiguration = EcrRepositoryConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
