// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The proposed access control configuration for an Amazon EBS volume snapshot. You can propose a configuration for a new Amazon EBS volume snapshot or an Amazon EBS volume snapshot that you own by specifying the user IDs, groups, and optional KMS encryption key. For more information, see [ModifySnapshotAttribute](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySnapshotAttribute.html).
 */
public class EbsSnapshotConfiguration private constructor(builder: Builder) {
    /**
     * The groups that have access to the Amazon EBS volume snapshot. If the value `all` is specified, then the Amazon EBS volume snapshot is public.
     * + If the configuration is for an existing Amazon EBS volume snapshot and you do not specify the `groups`, then the access preview uses the existing shared `groups` for the snapshot.
     * + If the access preview is for a new resource and you do not specify the `groups`, then the access preview considers the snapshot without any `groups`.
     * + To propose deletion of existing shared `groups`, you can specify an empty list for `groups`.
     */
    public val groups: List<String>? = builder.groups
    /**
     * The KMS key identifier for an encrypted Amazon EBS volume snapshot. The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * + If the configuration is for an existing Amazon EBS volume snapshot and you do not specify the `kmsKeyId`, or you specify an empty string, then the access preview uses the existing `kmsKeyId` of the snapshot.
     * + If the access preview is for a new resource and you do not specify the `kmsKeyId`, the access preview considers the snapshot as unencrypted.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The IDs of the Amazon Web Services accounts that have access to the Amazon EBS volume snapshot.
     * + If the configuration is for an existing Amazon EBS volume snapshot and you do not specify the `userIds`, then the access preview uses the existing shared `userIds` for the snapshot.
     * + If the access preview is for a new resource and you do not specify the `userIds`, then the access preview considers the snapshot without any `userIds`.
     * + To propose deletion of existing shared `accountIds`, you can specify an empty list for `userIds`.
     */
    public val userIds: List<String>? = builder.userIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.EbsSnapshotConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsSnapshotConfiguration(")
        append("groups=$groups,")
        append("kmsKeyId=$kmsKeyId,")
        append("userIds=$userIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groups?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsSnapshotConfiguration

        if (groups != other.groups) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (userIds != other.userIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.EbsSnapshotConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The groups that have access to the Amazon EBS volume snapshot. If the value `all` is specified, then the Amazon EBS volume snapshot is public.
         * + If the configuration is for an existing Amazon EBS volume snapshot and you do not specify the `groups`, then the access preview uses the existing shared `groups` for the snapshot.
         * + If the access preview is for a new resource and you do not specify the `groups`, then the access preview considers the snapshot without any `groups`.
         * + To propose deletion of existing shared `groups`, you can specify an empty list for `groups`.
         */
        public var groups: List<String>? = null
        /**
         * The KMS key identifier for an encrypted Amazon EBS volume snapshot. The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * + If the configuration is for an existing Amazon EBS volume snapshot and you do not specify the `kmsKeyId`, or you specify an empty string, then the access preview uses the existing `kmsKeyId` of the snapshot.
         * + If the access preview is for a new resource and you do not specify the `kmsKeyId`, the access preview considers the snapshot as unencrypted.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The IDs of the Amazon Web Services accounts that have access to the Amazon EBS volume snapshot.
         * + If the configuration is for an existing Amazon EBS volume snapshot and you do not specify the `userIds`, then the access preview uses the existing shared `userIds` for the snapshot.
         * + If the access preview is for a new resource and you do not specify the `userIds`, then the access preview considers the snapshot without any `userIds`.
         * + To propose deletion of existing shared `accountIds`, you can specify an empty list for `userIds`.
         */
        public var userIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.EbsSnapshotConfiguration) : this() {
            this.groups = x.groups
            this.kmsKeyId = x.kmsKeyId
            this.userIds = x.userIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.EbsSnapshotConfiguration = EbsSnapshotConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
