// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Creates an analyzer.
 */
public class CreateAnalyzerRequest private constructor(builder: Builder) {
    /**
     * The name of the analyzer to create.
     */
    public val analyzerName: kotlin.String = requireNotNull(builder.analyzerName) { "A non-null value must be provided for analyzerName" }
    /**
     * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.
     */
    public val archiveRules: List<InlineArchiveRule>? = builder.archiveRules
    /**
     * A client token.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Specifies the configuration of the analyzer. If the analyzer is an unused access analyzer, the specified scope of unused access is used for the configuration. If the analyzer is an external access analyzer, this field is not used.
     */
    public val configuration: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerConfiguration? = builder.configuration
    /**
     * An array of key-value pairs to apply to the analyzer.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of analyzer to create. Only `ACCOUNT`, `ORGANIZATION`, `ACCOUNT_UNUSED_ACCESS`, and `ORGANIZATION_UNUSED_ACCESS` analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.
     */
    public val type: aws.sdk.kotlin.services.accessanalyzer.model.Type = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.CreateAnalyzerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAnalyzerRequest(")
        append("analyzerName=$analyzerName,")
        append("archiveRules=$archiveRules,")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerName.hashCode()
        result = 31 * result + (archiveRules?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAnalyzerRequest

        if (analyzerName != other.analyzerName) return false
        if (archiveRules != other.archiveRules) return false
        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.CreateAnalyzerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the analyzer to create.
         */
        public var analyzerName: kotlin.String? = null
        /**
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.
         */
        public var archiveRules: List<InlineArchiveRule>? = null
        /**
         * A client token.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Specifies the configuration of the analyzer. If the analyzer is an unused access analyzer, the specified scope of unused access is used for the configuration. If the analyzer is an external access analyzer, this field is not used.
         */
        public var configuration: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerConfiguration? = null
        /**
         * An array of key-value pairs to apply to the analyzer.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of analyzer to create. Only `ACCOUNT`, `ORGANIZATION`, `ACCOUNT_UNUSED_ACCESS`, and `ORGANIZATION_UNUSED_ACCESS` analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.
         */
        public var type: aws.sdk.kotlin.services.accessanalyzer.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.CreateAnalyzerRequest) : this() {
            this.analyzerName = x.analyzerName
            this.archiveRules = x.archiveRules
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.CreateAnalyzerRequest = CreateAnalyzerRequest(this)

        internal fun correctErrors(): Builder {
            if (analyzerName == null) analyzerName = ""
            if (type == null) type = Type.SdkUnknown("no value provided")
            return this
        }
    }
}
