// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



public class CreateAccessPreviewRequest private constructor(builder: Builder) {
    /**
     * The [ARN of the account analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) used to generate the access preview. You can only create an access preview for analyzers with an `Account` type and `Active` status.
     */
    public val analyzerArn: kotlin.String = requireNotNull(builder.analyzerArn) { "A non-null value must be provided for analyzerArn" }
    /**
     * A client token.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.
     */
    public val configurations: Map<String, Configuration> = requireNotNull(builder.configurations) { "A non-null value must be provided for configurations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.CreateAccessPreviewRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessPreviewRequest(")
        append("analyzerArn=$analyzerArn,")
        append("clientToken=$clientToken,")
        append("configurations=$configurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn.hashCode()
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (configurations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessPreviewRequest

        if (analyzerArn != other.analyzerArn) return false
        if (clientToken != other.clientToken) return false
        if (configurations != other.configurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.CreateAccessPreviewRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The [ARN of the account analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) used to generate the access preview. You can only create an access preview for analyzers with an `Account` type and `Active` status.
         */
        public var analyzerArn: kotlin.String? = null
        /**
         * A client token.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.
         */
        public var configurations: Map<String, Configuration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.CreateAccessPreviewRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.clientToken = x.clientToken
            this.configurations = x.configurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.CreateAccessPreviewRequest = CreateAccessPreviewRequest(this)

        internal fun correctErrors(): Builder {
            if (analyzerArn == null) analyzerArn = ""
            if (configurations == null) configurations = emptyMap()
            return this
        }
    }
}
