// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about CloudTrail access.
 */
public class CloudTrailProperties private constructor(builder: Builder) {
    /**
     * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * A `TrailProperties` object that contains settings for trail properties.
     */
    public val trailProperties: List<TrailProperties> = requireNotNull(builder.trailProperties) { "A non-null value must be provided for trailProperties" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudTrailProperties(")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("trailProperties=$trailProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime.hashCode()
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (trailProperties.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudTrailProperties

        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (trailProperties != other.trailProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A `TrailProperties` object that contains settings for trail properties.
         */
        public var trailProperties: List<TrailProperties>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailProperties) : this() {
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.trailProperties = x.trailProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailProperties = CloudTrailProperties(this)

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (trailProperties == null) trailProperties = emptyList()
            return this
        }
    }
}
