// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about CloudTrail access.
 */
public class CloudTrailDetails private constructor(builder: Builder) {
    /**
     * The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and service last accessed information.
     */
    public val accessRole: kotlin.String = requireNotNull(builder.accessRole) { "A non-null value must be provided for accessRole" }
    /**
     * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * A `Trail` object that contains settings for a trail.
     */
    public val trails: List<Trail> = requireNotNull(builder.trails) { "A non-null value must be provided for trails" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudTrailDetails(")
        append("accessRole=$accessRole,")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("trails=$trails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessRole.hashCode()
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (trails.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudTrailDetails

        if (accessRole != other.accessRole) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (trails != other.trails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and service last accessed information.
         */
        public var accessRole: kotlin.String? = null
        /**
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A `Trail` object that contains settings for a trail.
         */
        public var trails: List<Trail>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailDetails) : this() {
            this.accessRole = x.accessRole
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.trails = x.trails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.CloudTrailDetails = CloudTrailDetails(this)

        internal fun correctErrors(): Builder {
            if (accessRole == null) accessRole = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (trails == null) trails = emptyList()
            return this
        }
    }
}
