// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an archive rule.
 */
public class ArchiveRuleSummary private constructor(builder: Builder) {
    /**
     * The time at which the archive rule was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * A filter used to define the archive rule.
     */
    public val filter: Map<String, Criterion> = requireNotNull(builder.filter) { "A non-null value must be provided for filter" }
    /**
     * The name of the archive rule.
     */
    public val ruleName: kotlin.String = requireNotNull(builder.ruleName) { "A non-null value must be provided for ruleName" }
    /**
     * The time at which the archive rule was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.ArchiveRuleSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ArchiveRuleSummary(")
        append("createdAt=$createdAt,")
        append("filter=$filter,")
        append("ruleName=$ruleName,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (filter.hashCode())
        result = 31 * result + (ruleName.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ArchiveRuleSummary

        if (createdAt != other.createdAt) return false
        if (filter != other.filter) return false
        if (ruleName != other.ruleName) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.ArchiveRuleSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the archive rule was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A filter used to define the archive rule.
         */
        public var filter: Map<String, Criterion>? = null
        /**
         * The name of the archive rule.
         */
        public var ruleName: kotlin.String? = null
        /**
         * The time at which the archive rule was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.ArchiveRuleSummary) : this() {
            this.createdAt = x.createdAt
            this.filter = x.filter
            this.ruleName = x.ruleName
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.ArchiveRuleSummary = ArchiveRuleSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (filter == null) filter = emptyMap()
            if (ruleName == null) ruleName = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
