// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the analyzer.
 */
public class AnalyzerSummary private constructor(builder: Builder) {
    /**
     * The ARN of the analyzer.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Specifies whether the analyzer is an external access or unused access analyzer.
     */
    public val configuration: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerConfiguration? = builder.configuration
    /**
     * A timestamp for the time at which the analyzer was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The resource that was most recently analyzed by the analyzer.
     */
    public val lastResourceAnalyzed: kotlin.String? = builder.lastResourceAnalyzed
    /**
     * The time at which the most recently analyzed resource was analyzed.
     */
    public val lastResourceAnalyzedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastResourceAnalyzedAt
    /**
     * The name of the analyzer.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the analyzer. An `Active` analyzer successfully monitors supported resources and generates new findings. The analyzer is `Disabled` when a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes the analyzer to stop generating new findings. The status is `Creating` when the analyzer creation is in progress and `Failed` when the analyzer creation has failed.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The `statusReason` provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a `Failed` status is returned. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the Amazon Web Services organization.
     */
    public val statusReason: aws.sdk.kotlin.services.accessanalyzer.model.StatusReason? = builder.statusReason
    /**
     * The tags added to the analyzer.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
     */
    public val type: aws.sdk.kotlin.services.accessanalyzer.model.Type = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyzerSummary(")
        append("arn=$arn,")
        append("configuration=$configuration,")
        append("createdAt=$createdAt,")
        append("lastResourceAnalyzed=$lastResourceAnalyzed,")
        append("lastResourceAnalyzedAt=$lastResourceAnalyzedAt,")
        append("name=$name,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (lastResourceAnalyzed?.hashCode() ?: 0)
        result = 31 * result + (lastResourceAnalyzedAt?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyzerSummary

        if (arn != other.arn) return false
        if (configuration != other.configuration) return false
        if (createdAt != other.createdAt) return false
        if (lastResourceAnalyzed != other.lastResourceAnalyzed) return false
        if (lastResourceAnalyzedAt != other.lastResourceAnalyzedAt) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the analyzer.
         */
        public var arn: kotlin.String? = null
        /**
         * Specifies whether the analyzer is an external access or unused access analyzer.
         */
        public var configuration: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerConfiguration? = null
        /**
         * A timestamp for the time at which the analyzer was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource that was most recently analyzed by the analyzer.
         */
        public var lastResourceAnalyzed: kotlin.String? = null
        /**
         * The time at which the most recently analyzed resource was analyzed.
         */
        public var lastResourceAnalyzedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the analyzer.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the analyzer. An `Active` analyzer successfully monitors supported resources and generates new findings. The analyzer is `Disabled` when a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes the analyzer to stop generating new findings. The status is `Creating` when the analyzer creation is in progress and `Failed` when the analyzer creation has failed.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerStatus? = null
        /**
         * The `statusReason` provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a `Failed` status is returned. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the Amazon Web Services organization.
         */
        public var statusReason: aws.sdk.kotlin.services.accessanalyzer.model.StatusReason? = null
        /**
         * The tags added to the analyzer.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
         */
        public var type: aws.sdk.kotlin.services.accessanalyzer.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerSummary) : this() {
            this.arn = x.arn
            this.configuration = x.configuration
            this.createdAt = x.createdAt
            this.lastResourceAnalyzed = x.lastResourceAnalyzed
            this.lastResourceAnalyzedAt = x.lastResourceAnalyzedAt
            this.name = x.name
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.AnalyzerSummary = AnalyzerSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.StatusReason] inside the given [block]
         */
        public fun statusReason(block: aws.sdk.kotlin.services.accessanalyzer.model.StatusReason.Builder.() -> kotlin.Unit) {
            this.statusReason = aws.sdk.kotlin.services.accessanalyzer.model.StatusReason.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = AnalyzerStatus.SdkUnknown("no value provided")
            if (type == null) type = Type.SdkUnknown("no value provided")
            return this
        }
    }
}
