// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the analyzed resource.
 */
public class AnalyzedResource private constructor(builder: Builder) {
    /**
     * The actions that an external principal is granted permission to use by the policy that generated the finding.
     */
    public val actions: List<String>? = builder.actions
    /**
     * The time at which the resource was analyzed.
     */
    public val analyzedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.analyzedAt) { "A non-null value must be provided for analyzedAt" }
    /**
     * The time at which the finding was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * An error message.
     */
    public val error: kotlin.String? = builder.error
    /**
     * Indicates whether the policy that generated the finding grants public access to the resource.
     */
    public val isPublic: kotlin.Boolean = requireNotNull(builder.isPublic) { "A non-null value must be provided for isPublic" }
    /**
     * The ARN of the resource that was analyzed.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * The Amazon Web Services account ID that owns the resource.
     */
    public val resourceOwnerAccount: kotlin.String = requireNotNull(builder.resourceOwnerAccount) { "A non-null value must be provided for resourceOwnerAccount" }
    /**
     * The type of the resource that was analyzed.
     */
    public val resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.
     */
    public val sharedVia: List<String>? = builder.sharedVia
    /**
     * The current status of the finding generated from the analyzed resource.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = builder.status
    /**
     * The time at which the finding was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.AnalyzedResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyzedResource(")
        append("actions=$actions,")
        append("analyzedAt=$analyzedAt,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("isPublic=$isPublic,")
        append("resourceArn=$resourceArn,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("sharedVia=$sharedVia,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (analyzedAt.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (isPublic.hashCode())
        result = 31 * result + (resourceArn.hashCode())
        result = 31 * result + (resourceOwnerAccount.hashCode())
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (sharedVia?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyzedResource

        if (actions != other.actions) return false
        if (analyzedAt != other.analyzedAt) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (isPublic != other.isPublic) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (sharedVia != other.sharedVia) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.AnalyzedResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actions that an external principal is granted permission to use by the policy that generated the finding.
         */
        public var actions: List<String>? = null
        /**
         * The time at which the resource was analyzed.
         */
        public var analyzedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the finding was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An error message.
         */
        public var error: kotlin.String? = null
        /**
         * Indicates whether the policy that generated the finding grants public access to the resource.
         */
        public var isPublic: kotlin.Boolean? = null
        /**
         * The ARN of the resource that was analyzed.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that owns the resource.
         */
        public var resourceOwnerAccount: kotlin.String? = null
        /**
         * The type of the resource that was analyzed.
         */
        public var resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType? = null
        /**
         * Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.
         */
        public var sharedVia: List<String>? = null
        /**
         * The current status of the finding generated from the analyzed resource.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = null
        /**
         * The time at which the finding was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.AnalyzedResource) : this() {
            this.actions = x.actions
            this.analyzedAt = x.analyzedAt
            this.createdAt = x.createdAt
            this.error = x.error
            this.isPublic = x.isPublic
            this.resourceArn = x.resourceArn
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.sharedVia = x.sharedVia
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.AnalyzedResource = AnalyzedResource(this)

        internal fun correctErrors(): Builder {
            if (analyzedAt == null) analyzedAt = Instant.fromEpochSeconds(0)
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (isPublic == null) isPublic = false
            if (resourceArn == null) resourceArn = ""
            if (resourceOwnerAccount == null) resourceOwnerAccount = ""
            if (resourceType == null) resourceType = ResourceType.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
