// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An access preview finding generated by the access preview.
 */
public class AccessPreviewFinding private constructor(builder: Builder) {
    /**
     * The action in the analyzed policy statement that an external principal has permission to perform.
     */
    public val action: List<String>? = builder.action
    /**
     * Provides context on how the access preview finding compares to existing access identified in IAM Access Analyzer.
     * + `New` - The finding is for newly-introduced access.
     * + `Unchanged` - The preview finding is an existing finding that would remain unchanged.
     * + `Changed` - The preview finding is an existing finding with a change in status.
     *
     * For example, a `Changed` finding with preview status `Resolved` and existing status `Active` indicates the existing `Active` finding would become `Resolved` as a result of the proposed permissions change.
     */
    public val changeType: aws.sdk.kotlin.services.accessanalyzer.model.FindingChangeType = requireNotNull(builder.changeType) { "A non-null value must be provided for changeType" }
    /**
     * The condition in the analyzed policy statement that resulted in a finding.
     */
    public val condition: Map<String, String>? = builder.condition
    /**
     * The time at which the access preview finding was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * An error.
     */
    public val error: kotlin.String? = builder.error
    /**
     * The existing ID of the finding in IAM Access Analyzer, provided only for existing findings.
     */
    public val existingFindingId: kotlin.String? = builder.existingFindingId
    /**
     * The existing status of the finding, provided only for existing findings.
     */
    public val existingFindingStatus: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = builder.existingFindingStatus
    /**
     * The ID of the access preview finding. This ID uniquely identifies the element in the list of access preview findings and is not related to the finding ID in Access Analyzer.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Indicates whether the policy that generated the finding allows public access to the resource.
     */
    public val isPublic: kotlin.Boolean? = builder.isPublic
    /**
     * The external principal that has access to a resource within the zone of trust.
     */
    public val principal: Map<String, String>? = builder.principal
    /**
     * The resource that an external principal has access to. This is the resource associated with the access preview.
     */
    public val resource: kotlin.String? = builder.resource
    /**
     * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning account is the account in which the resource was created.
     */
    public val resourceOwnerAccount: kotlin.String = requireNotNull(builder.resourceOwnerAccount) { "A non-null value must be provided for resourceOwnerAccount" }
    /**
     * The type of the resource that can be accessed in the finding.
     */
    public val resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
     */
    public val sources: List<FindingSource>? = builder.sources
    /**
     * The preview status of the finding. This is what the status of the finding would be after permissions deployment. For example, a `Changed` finding with preview status `Resolved` and existing status `Active` indicates the existing `Active` finding would become `Resolved` as a result of the proposed permissions change.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewFinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPreviewFinding(")
        append("action=$action,")
        append("changeType=$changeType,")
        append("condition=$condition,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("existingFindingId=$existingFindingId,")
        append("existingFindingStatus=$existingFindingStatus,")
        append("id=$id,")
        append("isPublic=$isPublic,")
        append("principal=$principal,")
        append("resource=$resource,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("sources=$sources,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (changeType.hashCode())
        result = 31 * result + (condition?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (existingFindingId?.hashCode() ?: 0)
        result = 31 * result + (existingFindingStatus?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (isPublic?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerAccount.hashCode())
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessPreviewFinding

        if (action != other.action) return false
        if (changeType != other.changeType) return false
        if (condition != other.condition) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (existingFindingId != other.existingFindingId) return false
        if (existingFindingStatus != other.existingFindingStatus) return false
        if (id != other.id) return false
        if (isPublic != other.isPublic) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (sources != other.sources) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewFinding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action in the analyzed policy statement that an external principal has permission to perform.
         */
        public var action: List<String>? = null
        /**
         * Provides context on how the access preview finding compares to existing access identified in IAM Access Analyzer.
         * + `New` - The finding is for newly-introduced access.
         * + `Unchanged` - The preview finding is an existing finding that would remain unchanged.
         * + `Changed` - The preview finding is an existing finding with a change in status.
         *
         * For example, a `Changed` finding with preview status `Resolved` and existing status `Active` indicates the existing `Active` finding would become `Resolved` as a result of the proposed permissions change.
         */
        public var changeType: aws.sdk.kotlin.services.accessanalyzer.model.FindingChangeType? = null
        /**
         * The condition in the analyzed policy statement that resulted in a finding.
         */
        public var condition: Map<String, String>? = null
        /**
         * The time at which the access preview finding was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An error.
         */
        public var error: kotlin.String? = null
        /**
         * The existing ID of the finding in IAM Access Analyzer, provided only for existing findings.
         */
        public var existingFindingId: kotlin.String? = null
        /**
         * The existing status of the finding, provided only for existing findings.
         */
        public var existingFindingStatus: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = null
        /**
         * The ID of the access preview finding. This ID uniquely identifies the element in the list of access preview findings and is not related to the finding ID in Access Analyzer.
         */
        public var id: kotlin.String? = null
        /**
         * Indicates whether the policy that generated the finding allows public access to the resource.
         */
        public var isPublic: kotlin.Boolean? = null
        /**
         * The external principal that has access to a resource within the zone of trust.
         */
        public var principal: Map<String, String>? = null
        /**
         * The resource that an external principal has access to. This is the resource associated with the access preview.
         */
        public var resource: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning account is the account in which the resource was created.
         */
        public var resourceOwnerAccount: kotlin.String? = null
        /**
         * The type of the resource that can be accessed in the finding.
         */
        public var resourceType: aws.sdk.kotlin.services.accessanalyzer.model.ResourceType? = null
        /**
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
         */
        public var sources: List<FindingSource>? = null
        /**
         * The preview status of the finding. This is what the status of the finding would be after permissions deployment. For example, a `Changed` finding with preview status `Resolved` and existing status `Active` indicates the existing `Active` finding would become `Resolved` as a result of the proposed permissions change.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewFinding) : this() {
            this.action = x.action
            this.changeType = x.changeType
            this.condition = x.condition
            this.createdAt = x.createdAt
            this.error = x.error
            this.existingFindingId = x.existingFindingId
            this.existingFindingStatus = x.existingFindingStatus
            this.id = x.id
            this.isPublic = x.isPublic
            this.principal = x.principal
            this.resource = x.resource
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.sources = x.sources
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewFinding = AccessPreviewFinding(this)

        internal fun correctErrors(): Builder {
            if (changeType == null) changeType = FindingChangeType.SdkUnknown("no value provided")
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (resourceOwnerAccount == null) resourceOwnerAccount = ""
            if (resourceType == null) resourceType = ResourceType.SdkUnknown("no value provided")
            if (status == null) status = FindingStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
