// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an access preview.
 */
public class AccessPreview private constructor(builder: Builder) {
    /**
     * The ARN of the analyzer used to generate the access preview.
     */
    public val analyzerArn: kotlin.String = requireNotNull(builder.analyzerArn) { "A non-null value must be provided for analyzerArn" }
    /**
     * A map of resource ARNs for the proposed resource configuration.
     */
    public val configurations: Map<String, Configuration> = requireNotNull(builder.configurations) { "A non-null value must be provided for configurations" }
    /**
     * The time at which the access preview was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The unique ID for the access preview.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The status of the access preview.
     * + `Creating` - The access preview creation is in progress.
     * + `Completed` - The access preview is complete. You can preview findings for external access to the resource.
     * + `Failed` - The access preview creation has failed.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Provides more details about the current status of the access preview.
     *
     * For example, if the creation of the access preview fails, a `Failed` status is returned. This failure can be due to an internal issue with the analysis or due to an invalid resource configuration.
     */
    public val statusReason: aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatusReason? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.AccessPreview = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPreview(")
        append("analyzerArn=$analyzerArn,")
        append("configurations=$configurations,")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn.hashCode()
        result = 31 * result + (configurations.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessPreview

        if (analyzerArn != other.analyzerArn) return false
        if (configurations != other.configurations) return false
        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.AccessPreview = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the analyzer used to generate the access preview.
         */
        public var analyzerArn: kotlin.String? = null
        /**
         * A map of resource ARNs for the proposed resource configuration.
         */
        public var configurations: Map<String, Configuration>? = null
        /**
         * The time at which the access preview was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID for the access preview.
         */
        public var id: kotlin.String? = null
        /**
         * The status of the access preview.
         * + `Creating` - The access preview creation is in progress.
         * + `Completed` - The access preview is complete. You can preview findings for external access to the resource.
         * + `Failed` - The access preview creation has failed.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatus? = null
        /**
         * Provides more details about the current status of the access preview.
         *
         * For example, if the creation of the access preview fails, a `Failed` status is returned. This failure can be due to an internal issue with the analysis or due to an invalid resource configuration.
         */
        public var statusReason: aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatusReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.AccessPreview) : this() {
            this.analyzerArn = x.analyzerArn
            this.configurations = x.configurations
            this.createdAt = x.createdAt
            this.id = x.id
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.AccessPreview = AccessPreview(this)

        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatusReason] inside the given [block]
         */
        public fun statusReason(block: aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatusReason.Builder.() -> kotlin.Unit) {
            this.statusReason = aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatusReason.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (analyzerArn == null) analyzerArn = ""
            if (configurations == null) configurations = emptyMap()
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (status == null) status = AccessPreviewStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
