// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.accessanalyzer.auth.AccessAnalyzerAuthSchemeProvider
import aws.sdk.kotlin.services.accessanalyzer.auth.DefaultAccessAnalyzerAuthSchemeProvider
import aws.sdk.kotlin.services.accessanalyzer.endpoints.AccessAnalyzerEndpointParameters
import aws.sdk.kotlin.services.accessanalyzer.endpoints.AccessAnalyzerEndpointProvider
import aws.sdk.kotlin.services.accessanalyzer.endpoints.DefaultAccessAnalyzerEndpointProvider
import aws.sdk.kotlin.services.accessanalyzer.model.ApplyArchiveRuleRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ApplyArchiveRuleResponse
import aws.sdk.kotlin.services.accessanalyzer.model.CancelPolicyGenerationRequest
import aws.sdk.kotlin.services.accessanalyzer.model.CancelPolicyGenerationResponse
import aws.sdk.kotlin.services.accessanalyzer.model.CheckAccessNotGrantedRequest
import aws.sdk.kotlin.services.accessanalyzer.model.CheckAccessNotGrantedResponse
import aws.sdk.kotlin.services.accessanalyzer.model.CheckNoNewAccessRequest
import aws.sdk.kotlin.services.accessanalyzer.model.CheckNoNewAccessResponse
import aws.sdk.kotlin.services.accessanalyzer.model.CreateAccessPreviewRequest
import aws.sdk.kotlin.services.accessanalyzer.model.CreateAccessPreviewResponse
import aws.sdk.kotlin.services.accessanalyzer.model.CreateAnalyzerRequest
import aws.sdk.kotlin.services.accessanalyzer.model.CreateAnalyzerResponse
import aws.sdk.kotlin.services.accessanalyzer.model.CreateArchiveRuleRequest
import aws.sdk.kotlin.services.accessanalyzer.model.CreateArchiveRuleResponse
import aws.sdk.kotlin.services.accessanalyzer.model.DeleteAnalyzerRequest
import aws.sdk.kotlin.services.accessanalyzer.model.DeleteAnalyzerResponse
import aws.sdk.kotlin.services.accessanalyzer.model.DeleteArchiveRuleRequest
import aws.sdk.kotlin.services.accessanalyzer.model.DeleteArchiveRuleResponse
import aws.sdk.kotlin.services.accessanalyzer.model.GetAccessPreviewRequest
import aws.sdk.kotlin.services.accessanalyzer.model.GetAccessPreviewResponse
import aws.sdk.kotlin.services.accessanalyzer.model.GetAnalyzedResourceRequest
import aws.sdk.kotlin.services.accessanalyzer.model.GetAnalyzedResourceResponse
import aws.sdk.kotlin.services.accessanalyzer.model.GetAnalyzerRequest
import aws.sdk.kotlin.services.accessanalyzer.model.GetAnalyzerResponse
import aws.sdk.kotlin.services.accessanalyzer.model.GetArchiveRuleRequest
import aws.sdk.kotlin.services.accessanalyzer.model.GetArchiveRuleResponse
import aws.sdk.kotlin.services.accessanalyzer.model.GetFindingRequest
import aws.sdk.kotlin.services.accessanalyzer.model.GetFindingResponse
import aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Request
import aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Response
import aws.sdk.kotlin.services.accessanalyzer.model.GetGeneratedPolicyRequest
import aws.sdk.kotlin.services.accessanalyzer.model.GetGeneratedPolicyResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewFindingsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzersRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzersResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListArchiveRulesRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListArchiveRulesResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsV2Request
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsV2Response
import aws.sdk.kotlin.services.accessanalyzer.model.ListPolicyGenerationsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListPolicyGenerationsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.accessanalyzer.model.StartPolicyGenerationRequest
import aws.sdk.kotlin.services.accessanalyzer.model.StartPolicyGenerationResponse
import aws.sdk.kotlin.services.accessanalyzer.model.StartResourceScanRequest
import aws.sdk.kotlin.services.accessanalyzer.model.StartResourceScanResponse
import aws.sdk.kotlin.services.accessanalyzer.model.TagResourceRequest
import aws.sdk.kotlin.services.accessanalyzer.model.TagResourceResponse
import aws.sdk.kotlin.services.accessanalyzer.model.UntagResourceRequest
import aws.sdk.kotlin.services.accessanalyzer.model.UntagResourceResponse
import aws.sdk.kotlin.services.accessanalyzer.model.UpdateArchiveRuleRequest
import aws.sdk.kotlin.services.accessanalyzer.model.UpdateArchiveRuleResponse
import aws.sdk.kotlin.services.accessanalyzer.model.UpdateFindingsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.UpdateFindingsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AccessAnalyzer"
public const val SdkVersion: String = "1.0.77"
public const val ServiceApiVersion: String = "2019-11-01"

/**
 * Identity and Access Management Access Analyzer helps you to set, verify, and refine your IAM policies by providing a suite of capabilities. Its features include findings for external and unused access, basic and custom policy checks for validating policies, and policy generation to generate fine-grained policies. To start using IAM Access Analyzer to identify external or unused access, you first need to create an analyzer.
 *
 * **External access analyzers** help identify potential risks of accessing resources by enabling you to identify any resource policies that grant access to an external principal. It does this by using logic-based reasoning to analyze resource-based policies in your Amazon Web Services environment. An external principal can be another Amazon Web Services account, a root user, an IAM user or role, a federated user, an Amazon Web Services service, or an anonymous user. You can also use IAM Access Analyzer to preview public and cross-account access to your resources before deploying permissions changes.
 *
 * **Unused access analyzers** help identify potential identity access risks by enabling you to identify unused IAM roles, unused access keys, unused console passwords, and IAM principals with unused service and action-level permissions.
 *
 * Beyond findings, IAM Access Analyzer provides basic and custom policy checks to validate IAM policies before deploying permissions changes. You can use policy generation to refine permissions by attaching a policy generated using access activity logged in CloudTrail logs.
 *
 * This guide describes the IAM Access Analyzer operations that you can call programmatically. For general information about IAM Access Analyzer, see [Identity and Access Management Access Analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html) in the **IAM User Guide**.
 */
public interface AccessAnalyzerClient : SdkClient {
    /**
     * AccessAnalyzerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AccessAnalyzerClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AccessAnalyzer",
                "ACCESSANALYZER",
                "accessanalyzer",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AccessAnalyzerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AccessAnalyzerClient = DefaultAccessAnalyzerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AccessAnalyzerEndpointProvider = builder.endpointProvider ?: DefaultAccessAnalyzerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AccessAnalyzerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAccessAnalyzerAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AccessAnalyzer"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AccessAnalyzerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AccessAnalyzerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Retroactively applies the archive rule to existing findings that meet the archive rule criteria.
     */
    public suspend fun applyArchiveRule(input: ApplyArchiveRuleRequest): ApplyArchiveRuleResponse

    /**
     * Cancels the requested policy generation.
     */
    public suspend fun cancelPolicyGeneration(input: CancelPolicyGenerationRequest): CancelPolicyGenerationResponse

    /**
     * Checks whether the specified access isn't allowed by a policy.
     */
    public suspend fun checkAccessNotGranted(input: CheckAccessNotGrantedRequest): CheckAccessNotGrantedResponse

    /**
     * Checks whether new access is allowed for an updated policy when compared to the existing policy.
     *
     * You can find examples for reference policies and learn how to set up and run a custom policy check for new access in the [IAM Access Analyzer custom policy checks samples](https://github.com/aws-samples/iam-access-analyzer-custom-policy-check-samples) repository on GitHub. The reference policies in this repository are meant to be passed to the `existingPolicyDocument` request parameter.
     */
    public suspend fun checkNoNewAccess(input: CheckNoNewAccessRequest): CheckNoNewAccessResponse

    /**
     * Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions.
     */
    public suspend fun createAccessPreview(input: CreateAccessPreviewRequest): CreateAccessPreviewResponse

    /**
     * Creates an analyzer for your account.
     */
    public suspend fun createAnalyzer(input: CreateAnalyzerRequest): CreateAnalyzerResponse

    /**
     * Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
     *
     * To learn about filter keys that you can use to create an archive rule, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
     */
    public suspend fun createArchiveRule(input: CreateArchiveRuleRequest): CreateArchiveRuleResponse

    /**
     * Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.
     */
    public suspend fun deleteAnalyzer(input: DeleteAnalyzerRequest): DeleteAnalyzerResponse

    /**
     * Deletes the specified archive rule.
     */
    public suspend fun deleteArchiveRule(input: DeleteArchiveRuleRequest): DeleteArchiveRuleResponse

    /**
     * Retrieves information about an access preview for the specified analyzer.
     */
    public suspend fun getAccessPreview(input: GetAccessPreviewRequest): GetAccessPreviewResponse

    /**
     * Retrieves information about a resource that was analyzed.
     */
    public suspend fun getAnalyzedResource(input: GetAnalyzedResourceRequest): GetAnalyzedResourceResponse

    /**
     * Retrieves information about the specified analyzer.
     */
    public suspend fun getAnalyzer(input: GetAnalyzerRequest): GetAnalyzerResponse

    /**
     * Retrieves information about an archive rule.
     *
     * To learn about filter keys that you can use to create an archive rule, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
     */
    public suspend fun getArchiveRule(input: GetArchiveRuleRequest): GetArchiveRuleResponse

    /**
     * Retrieves information about the specified finding. GetFinding and GetFindingV2 both use `access-analyzer:GetFinding` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:GetFinding` action.
     */
    public suspend fun getFinding(input: GetFindingRequest): GetFindingResponse

    /**
     * Retrieves information about the specified finding. GetFinding and GetFindingV2 both use `access-analyzer:GetFinding` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:GetFinding` action.
     */
    public suspend fun getFindingV2(input: GetFindingV2Request): GetFindingV2Response

    /**
     * Retrieves the policy that was generated using `StartPolicyGeneration`.
     */
    public suspend fun getGeneratedPolicy(input: GetGeneratedPolicyRequest): GetGeneratedPolicyResponse

    /**
     * Retrieves a list of access preview findings generated by the specified access preview.
     */
    public suspend fun listAccessPreviewFindings(input: ListAccessPreviewFindingsRequest): ListAccessPreviewFindingsResponse

    /**
     * Retrieves a list of access previews for the specified analyzer.
     */
    public suspend fun listAccessPreviews(input: ListAccessPreviewsRequest): ListAccessPreviewsResponse

    /**
     * Retrieves a list of resources of the specified type that have been analyzed by the specified external access analyzer. This action is not supported for unused access analyzers.
     */
    public suspend fun listAnalyzedResources(input: ListAnalyzedResourcesRequest): ListAnalyzedResourcesResponse

    /**
     * Retrieves a list of analyzers.
     */
    public suspend fun listAnalyzers(input: ListAnalyzersRequest = ListAnalyzersRequest { }): ListAnalyzersResponse

    /**
     * Retrieves a list of archive rules created for the specified analyzer.
     */
    public suspend fun listArchiveRules(input: ListArchiveRulesRequest): ListArchiveRulesResponse

    /**
     * Retrieves a list of findings generated by the specified analyzer. ListFindings and ListFindingsV2 both use `access-analyzer:ListFindings` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:ListFindings` action.
     *
     * To learn about filter keys that you can use to retrieve a list of findings, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
     */
    public suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse

    /**
     * Retrieves a list of findings generated by the specified analyzer. ListFindings and ListFindingsV2 both use `access-analyzer:ListFindings` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:ListFindings` action.
     *
     * To learn about filter keys that you can use to retrieve a list of findings, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
     */
    public suspend fun listFindingsV2(input: ListFindingsV2Request): ListFindingsV2Response

    /**
     * Lists all of the policy generations requested in the last seven days.
     */
    public suspend fun listPolicyGenerations(input: ListPolicyGenerationsRequest = ListPolicyGenerationsRequest { }): ListPolicyGenerationsResponse

    /**
     * Retrieves a list of tags applied to the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts the policy generation request.
     */
    public suspend fun startPolicyGeneration(input: StartPolicyGenerationRequest): StartPolicyGenerationResponse

    /**
     * Immediately starts a scan of the policies applied to the specified resource.
     */
    public suspend fun startResourceScan(input: StartResourceScanRequest): StartResourceScanResponse

    /**
     * Adds a tag to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the criteria and values for the specified archive rule.
     */
    public suspend fun updateArchiveRule(input: UpdateArchiveRuleRequest): UpdateArchiveRuleResponse

    /**
     * Updates the status for the specified findings.
     */
    public suspend fun updateFindings(input: UpdateFindingsRequest): UpdateFindingsResponse

    /**
     * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices.
     */
    public suspend fun validatePolicy(input: ValidatePolicyRequest): ValidatePolicyResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AccessAnalyzerClient.withConfig(block: AccessAnalyzerClient.Config.Builder.() -> Unit): AccessAnalyzerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAccessAnalyzerClient(newConfig)
}

/**
 * Retroactively applies the archive rule to existing findings that meet the archive rule criteria.
 */
public suspend inline fun AccessAnalyzerClient.applyArchiveRule(crossinline block: ApplyArchiveRuleRequest.Builder.() -> Unit): ApplyArchiveRuleResponse = applyArchiveRule(ApplyArchiveRuleRequest.Builder().apply(block).build())

/**
 * Cancels the requested policy generation.
 */
public suspend inline fun AccessAnalyzerClient.cancelPolicyGeneration(crossinline block: CancelPolicyGenerationRequest.Builder.() -> Unit): CancelPolicyGenerationResponse = cancelPolicyGeneration(CancelPolicyGenerationRequest.Builder().apply(block).build())

/**
 * Checks whether the specified access isn't allowed by a policy.
 */
public suspend inline fun AccessAnalyzerClient.checkAccessNotGranted(crossinline block: CheckAccessNotGrantedRequest.Builder.() -> Unit): CheckAccessNotGrantedResponse = checkAccessNotGranted(CheckAccessNotGrantedRequest.Builder().apply(block).build())

/**
 * Checks whether new access is allowed for an updated policy when compared to the existing policy.
 *
 * You can find examples for reference policies and learn how to set up and run a custom policy check for new access in the [IAM Access Analyzer custom policy checks samples](https://github.com/aws-samples/iam-access-analyzer-custom-policy-check-samples) repository on GitHub. The reference policies in this repository are meant to be passed to the `existingPolicyDocument` request parameter.
 */
public suspend inline fun AccessAnalyzerClient.checkNoNewAccess(crossinline block: CheckNoNewAccessRequest.Builder.() -> Unit): CheckNoNewAccessResponse = checkNoNewAccess(CheckNoNewAccessRequest.Builder().apply(block).build())

/**
 * Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions.
 */
public suspend inline fun AccessAnalyzerClient.createAccessPreview(crossinline block: CreateAccessPreviewRequest.Builder.() -> Unit): CreateAccessPreviewResponse = createAccessPreview(CreateAccessPreviewRequest.Builder().apply(block).build())

/**
 * Creates an analyzer for your account.
 */
public suspend inline fun AccessAnalyzerClient.createAnalyzer(crossinline block: CreateAnalyzerRequest.Builder.() -> Unit): CreateAnalyzerResponse = createAnalyzer(CreateAnalyzerRequest.Builder().apply(block).build())

/**
 * Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
 *
 * To learn about filter keys that you can use to create an archive rule, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
 */
public suspend inline fun AccessAnalyzerClient.createArchiveRule(crossinline block: CreateArchiveRuleRequest.Builder.() -> Unit): CreateArchiveRuleResponse = createArchiveRule(CreateArchiveRuleRequest.Builder().apply(block).build())

/**
 * Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.
 */
public suspend inline fun AccessAnalyzerClient.deleteAnalyzer(crossinline block: DeleteAnalyzerRequest.Builder.() -> Unit): DeleteAnalyzerResponse = deleteAnalyzer(DeleteAnalyzerRequest.Builder().apply(block).build())

/**
 * Deletes the specified archive rule.
 */
public suspend inline fun AccessAnalyzerClient.deleteArchiveRule(crossinline block: DeleteArchiveRuleRequest.Builder.() -> Unit): DeleteArchiveRuleResponse = deleteArchiveRule(DeleteArchiveRuleRequest.Builder().apply(block).build())

/**
 * Retrieves information about an access preview for the specified analyzer.
 */
public suspend inline fun AccessAnalyzerClient.getAccessPreview(crossinline block: GetAccessPreviewRequest.Builder.() -> Unit): GetAccessPreviewResponse = getAccessPreview(GetAccessPreviewRequest.Builder().apply(block).build())

/**
 * Retrieves information about a resource that was analyzed.
 */
public suspend inline fun AccessAnalyzerClient.getAnalyzedResource(crossinline block: GetAnalyzedResourceRequest.Builder.() -> Unit): GetAnalyzedResourceResponse = getAnalyzedResource(GetAnalyzedResourceRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified analyzer.
 */
public suspend inline fun AccessAnalyzerClient.getAnalyzer(crossinline block: GetAnalyzerRequest.Builder.() -> Unit): GetAnalyzerResponse = getAnalyzer(GetAnalyzerRequest.Builder().apply(block).build())

/**
 * Retrieves information about an archive rule.
 *
 * To learn about filter keys that you can use to create an archive rule, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
 */
public suspend inline fun AccessAnalyzerClient.getArchiveRule(crossinline block: GetArchiveRuleRequest.Builder.() -> Unit): GetArchiveRuleResponse = getArchiveRule(GetArchiveRuleRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified finding. GetFinding and GetFindingV2 both use `access-analyzer:GetFinding` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:GetFinding` action.
 */
public suspend inline fun AccessAnalyzerClient.getFinding(crossinline block: GetFindingRequest.Builder.() -> Unit): GetFindingResponse = getFinding(GetFindingRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified finding. GetFinding and GetFindingV2 both use `access-analyzer:GetFinding` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:GetFinding` action.
 */
public suspend inline fun AccessAnalyzerClient.getFindingV2(crossinline block: GetFindingV2Request.Builder.() -> Unit): GetFindingV2Response = getFindingV2(GetFindingV2Request.Builder().apply(block).build())

/**
 * Retrieves the policy that was generated using `StartPolicyGeneration`.
 */
public suspend inline fun AccessAnalyzerClient.getGeneratedPolicy(crossinline block: GetGeneratedPolicyRequest.Builder.() -> Unit): GetGeneratedPolicyResponse = getGeneratedPolicy(GetGeneratedPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves a list of access preview findings generated by the specified access preview.
 */
public suspend inline fun AccessAnalyzerClient.listAccessPreviewFindings(crossinline block: ListAccessPreviewFindingsRequest.Builder.() -> Unit): ListAccessPreviewFindingsResponse = listAccessPreviewFindings(ListAccessPreviewFindingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of access previews for the specified analyzer.
 */
public suspend inline fun AccessAnalyzerClient.listAccessPreviews(crossinline block: ListAccessPreviewsRequest.Builder.() -> Unit): ListAccessPreviewsResponse = listAccessPreviews(ListAccessPreviewsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of resources of the specified type that have been analyzed by the specified external access analyzer. This action is not supported for unused access analyzers.
 */
public suspend inline fun AccessAnalyzerClient.listAnalyzedResources(crossinline block: ListAnalyzedResourcesRequest.Builder.() -> Unit): ListAnalyzedResourcesResponse = listAnalyzedResources(ListAnalyzedResourcesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of analyzers.
 */
public suspend inline fun AccessAnalyzerClient.listAnalyzers(crossinline block: ListAnalyzersRequest.Builder.() -> Unit): ListAnalyzersResponse = listAnalyzers(ListAnalyzersRequest.Builder().apply(block).build())

/**
 * Retrieves a list of archive rules created for the specified analyzer.
 */
public suspend inline fun AccessAnalyzerClient.listArchiveRules(crossinline block: ListArchiveRulesRequest.Builder.() -> Unit): ListArchiveRulesResponse = listArchiveRules(ListArchiveRulesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of findings generated by the specified analyzer. ListFindings and ListFindingsV2 both use `access-analyzer:ListFindings` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:ListFindings` action.
 *
 * To learn about filter keys that you can use to retrieve a list of findings, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
 */
public suspend inline fun AccessAnalyzerClient.listFindings(crossinline block: ListFindingsRequest.Builder.() -> Unit): ListFindingsResponse = listFindings(ListFindingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of findings generated by the specified analyzer. ListFindings and ListFindingsV2 both use `access-analyzer:ListFindings` in the `Action` element of an IAM policy statement. You must have permission to perform the `access-analyzer:ListFindings` action.
 *
 * To learn about filter keys that you can use to retrieve a list of findings, see [IAM Access Analyzer filter keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html) in the **IAM User Guide**.
 */
public suspend inline fun AccessAnalyzerClient.listFindingsV2(crossinline block: ListFindingsV2Request.Builder.() -> Unit): ListFindingsV2Response = listFindingsV2(ListFindingsV2Request.Builder().apply(block).build())

/**
 * Lists all of the policy generations requested in the last seven days.
 */
public suspend inline fun AccessAnalyzerClient.listPolicyGenerations(crossinline block: ListPolicyGenerationsRequest.Builder.() -> Unit): ListPolicyGenerationsResponse = listPolicyGenerations(ListPolicyGenerationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of tags applied to the specified resource.
 */
public suspend inline fun AccessAnalyzerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts the policy generation request.
 */
public suspend inline fun AccessAnalyzerClient.startPolicyGeneration(crossinline block: StartPolicyGenerationRequest.Builder.() -> Unit): StartPolicyGenerationResponse = startPolicyGeneration(StartPolicyGenerationRequest.Builder().apply(block).build())

/**
 * Immediately starts a scan of the policies applied to the specified resource.
 */
public suspend inline fun AccessAnalyzerClient.startResourceScan(crossinline block: StartResourceScanRequest.Builder.() -> Unit): StartResourceScanResponse = startResourceScan(StartResourceScanRequest.Builder().apply(block).build())

/**
 * Adds a tag to the specified resource.
 */
public suspend inline fun AccessAnalyzerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from the specified resource.
 */
public suspend inline fun AccessAnalyzerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the criteria and values for the specified archive rule.
 */
public suspend inline fun AccessAnalyzerClient.updateArchiveRule(crossinline block: UpdateArchiveRuleRequest.Builder.() -> Unit): UpdateArchiveRuleResponse = updateArchiveRule(UpdateArchiveRuleRequest.Builder().apply(block).build())

/**
 * Updates the status for the specified findings.
 */
public suspend inline fun AccessAnalyzerClient.updateFindings(crossinline block: UpdateFindingsRequest.Builder.() -> Unit): UpdateFindingsResponse = updateFindings(UpdateFindingsRequest.Builder().apply(block).build())

/**
 * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices.
 */
public suspend inline fun AccessAnalyzerClient.validatePolicy(crossinline block: ValidatePolicyRequest.Builder.() -> Unit): ValidatePolicyResponse = validatePolicy(ValidatePolicyRequest.Builder().apply(block).build())
