/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit.factory.syslog;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.logging.logkit.FormatterFactory;
import org.apache.avalon.logging.logkit.LogTargetException;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.logging.logkit.factory.syslog.SyslogTarget;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;

public class SyslogTargetFactory
implements LogTargetFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$factory$syslog$SyslogTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$syslog$SyslogTargetFactory = SyslogTargetFactory.class$("org.apache.avalon.logging.logkit.factory.syslog.SyslogTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$syslog$SyslogTargetFactory));
    private final FormatterFactory m_formatter;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$syslog$SyslogTargetFactory;

    public SyslogTargetFactory(FormatterFactory formatter) {
        this.m_formatter = formatter;
    }

    public LogTarget createTarget(Configuration conf) throws LogTargetException {
        Configuration formatConfig = conf.getChild("format");
        Formatter formatter = this.m_formatter.createFormatter(formatConfig);
        Configuration configChild = conf.getChild("address", false);
        if (null == configChild) {
            String error = REZ.getString("syslog.error.missing-address");
            throw new LogTargetException(error);
        }
        InetAddress address = this.getAddress(configChild);
        String name = this.getFacilityName(configChild);
        int facility = SyslogTarget.getFacilityValue(name);
        int port = this.getPort(configChild);
        try {
            return new SyslogTarget(address, port, formatter, facility);
        }
        catch (Throwable e) {
            String error = REZ.getString("syslog.error.internal");
            throw new LogTargetException(error, e);
        }
    }

    private InetAddress getAddress(Configuration config) throws LogTargetException {
        try {
            return InetAddress.getByName(config.getAttribute("hostname"));
        }
        catch (UnknownHostException uhex) {
            String error = REZ.getString("syslog.error.unknown-host");
            throw new LogTargetException(error, (Throwable)uhex);
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("syslog.error.missing-host");
            throw new LogTargetException(error, (Throwable)e);
        }
    }

    private String getFacilityName(Configuration config) throws LogTargetException {
        try {
            return config.getAttribute("facility");
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("syslog.error.missing-facility");
            throw new LogTargetException(error, (Throwable)e);
        }
    }

    private int getPort(Configuration config) throws LogTargetException {
        try {
            return config.getAttributeAsInteger("port");
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("syslog.error.missing-port");
            throw new LogTargetException(error, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

