/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit.factory.syslog;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.net.DatagramOutputTarget;

public class SyslogTarget
extends DatagramOutputTarget {
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    public static final int SYSLOG_FATAL = 0;
    public static final int SYSLOG_ERROR = 3;
    public static final int SYSLOG_WARN = 4;
    public static final int SYSLOG_INFO = 6;
    public static final int SYSLOG_DEBUG = 7;
    private int facility = 8;

    public SyslogTarget(InetAddress address, int port, Formatter formatter, int facility) throws IOException {
        super(address, port, formatter);
        this.facility = facility;
    }

    public SyslogTarget(InetAddress address, int port, Formatter formatter) throws IOException {
        super(address, port, formatter);
    }

    public SyslogTarget(InetAddress address, int port) throws IOException {
        super(address, port);
    }

    protected void doProcessEvent(LogEvent event) {
        int priority = event.getPriority().getValue();
        int syslogPriority = 6;
        switch (priority) {
            case 5: {
                syslogPriority = 7;
                break;
            }
            case 10: {
                syslogPriority = 6;
                break;
            }
            case 15: {
                syslogPriority = 4;
                break;
            }
            case 20: {
                syslogPriority = 3;
                break;
            }
            case 25: {
                syslogPriority = 0;
            }
        }
        if (null != this.getFormatter()) {
            this.write("<" + (this.facility | syslogPriority) + ">" + this.getFormatter().format(event));
        } else {
            this.write("<" + (this.facility | syslogPriority) + ">" + event.toString());
        }
    }

    public static int getFacilityValue(String name) {
        if (name.equalsIgnoreCase("kern")) {
            return 0;
        }
        if (name.equalsIgnoreCase("user")) {
            return 8;
        }
        if (name.equalsIgnoreCase("mail")) {
            return 16;
        }
        if (name.equalsIgnoreCase("daemon")) {
            return 24;
        }
        if (name.equalsIgnoreCase("auth")) {
            return 32;
        }
        if (name.equalsIgnoreCase("syslog")) {
            return 40;
        }
        if (name.equalsIgnoreCase("lpr")) {
            return 48;
        }
        if (name.equalsIgnoreCase("news")) {
            return 56;
        }
        if (name.equalsIgnoreCase("uucp")) {
            return 64;
        }
        if (name.equalsIgnoreCase("cron")) {
            return 72;
        }
        if (name.equalsIgnoreCase("authpriv")) {
            return 80;
        }
        if (name.equalsIgnoreCase("ftp")) {
            return 88;
        }
        if (name.equalsIgnoreCase("local0")) {
            return 128;
        }
        if (name.equalsIgnoreCase("local1")) {
            return 136;
        }
        if (name.equalsIgnoreCase("local2")) {
            return 144;
        }
        if (name.equalsIgnoreCase("local3")) {
            return 152;
        }
        if (name.equalsIgnoreCase("local4")) {
            return 160;
        }
        if (name.equalsIgnoreCase("local5")) {
            return 168;
        }
        if (name.equalsIgnoreCase("local6")) {
            return 176;
        }
        if (name.equalsIgnoreCase("local7")) {
            return 184;
        }
        return 8;
    }

    public void setFacility(String name) {
        this.facility = SyslogTarget.getFacilityValue(name);
    }

    public void setFacility(int value) {
        this.facility = value;
    }

    public int getFacility() {
        return this.facility;
    }
}

