/*
 * Decompiled with CFR 0.152.
 */
package wisp.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.resources.ResourceLoader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\u0007H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070!2\u0006\u0010&\u001a\u00020\u0007H\u0016J3\u0010*\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u00072!\u0010+\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001f0\u001bH\u0016J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0012H\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u001a\u001a)\u0012\u0004\u0012\u00020\u0012\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001f0\u001b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010 \u001a,\u0012(\u0012&\u0012\f\u0012\n #*\u0004\u0018\u00010\u00120\u0012 #*\u0012\u0012\f\u0012\n #*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\"0\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lwisp/resources/FilesystemLoaderBackend;", "Lwisp/resources/ResourceLoader$Backend;", "<init>", "()V", "logger", "Lmu/KLogger;", "SCHEME", "", "watcher", "Ljava/nio/file/WatchService;", "getWatcher", "()Ljava/nio/file/WatchService;", "watcher$delegate", "Lkotlin/Lazy;", "threadGroup", "Ljava/lang/ThreadGroup;", "watchedDirectoryThreads", "", "Ljava/nio/file/Path;", "Ljava/lang/Thread;", "getWatchedDirectoryThreads$wisp_resource_loader", "()Ljava/util/Map;", "watchedDirectoryPathCount", "", "watchedPaths", "", "resourceChangedListeners", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "address", "", "watchedEventKinds", "", "Ljava/nio/file/WatchEvent$Kind;", "kotlin.jvm.PlatformType", "open", "Lokio/BufferedSource;", "path", "exists", "", "list", "watch", "resourceChangedListener", "startWatcherThread", "directory", "unwatch", "wisp-resource-loader"})
@SourceDebugExtension(value={"SMAP\nFilesystemLoaderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilesystemLoaderBackend.kt\nwisp/resources/FilesystemLoaderBackend\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,143:1\n11158#2:144\n11493#2,3:145\n37#3:148\n36#3,3:149\n295#4,2:152\n13#5:154\n*S KotlinDebug\n*F\n+ 1 FilesystemLoaderBackend.kt\nwisp/resources/FilesystemLoaderBackend\n*L\n54#1:144\n54#1:145,3\n78#1:148\n78#1:149,3\n94#1:152,2\n18#1:154\n*E\n"})
public final class FilesystemLoaderBackend
extends ResourceLoader.Backend {
    @NotNull
    public static final FilesystemLoaderBackend INSTANCE = new FilesystemLoaderBackend();
    @NotNull
    private static final KLogger logger;
    @NotNull
    public static final String SCHEME = "filesystem:";
    @NotNull
    private static final Lazy watcher$delegate;
    @NotNull
    private static final ThreadGroup threadGroup;
    @NotNull
    private static final Map<Path, Thread> watchedDirectoryThreads;
    @NotNull
    private static final Map<Path, Integer> watchedDirectoryPathCount;
    @NotNull
    private static final Set<Path> watchedPaths;
    @NotNull
    private static Map<Path, Function1<String, Unit>> resourceChangedListeners;
    @NotNull
    private static final List<WatchEvent.Kind<Path>> watchedEventKinds;

    private FilesystemLoaderBackend() {
    }

    private final WatchService getWatcher() {
        Lazy lazy = watcher$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (WatchService)object;
    }

    @NotNull
    public final Map<Path, Thread> getWatchedDirectoryThreads$wisp_resource_loader() {
        return watchedDirectoryThreads;
    }

    @Override
    @Nullable
    public BufferedSource open(@NotNull String path) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        try {
            bufferedSource = Okio.buffer((Source)Okio.source((File)file));
        }
        catch (FileNotFoundException e) {
            bufferedSource = null;
        }
        return bufferedSource;
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(path).exists();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> list(@NotNull String path) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File[] fileArray = new File(path).listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(path + "/" + it.getName());
            }
            list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void watch(@NotNull String path, @NotNull Function1<? super String, Unit> resourceChangedListener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(resourceChangedListener, (String)"resourceChangedListener");
        Path file = Paths.get(path, new String[0]);
        Intrinsics.checkNotNull((Object)file);
        watchedPaths.add(file);
        resourceChangedListeners.put(file, resourceChangedListener);
        Path directory = file.getParent();
        Map<Path, Integer> map = watchedDirectoryPathCount;
        Integer n = watchedDirectoryPathCount.get(directory);
        Integer n2 = n != null ? n + 1 : 1;
        map.put(directory, n2);
        Thread thread = watchedDirectoryThreads.get(directory);
        boolean bl = thread != null ? thread.isAlive() : false;
        if (bl) {
            return;
        }
        logger.info(() -> FilesystemLoaderBackend.watch$lambda$2(directory));
        Collection $this$toTypedArray$iv = watchedEventKinds;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        directory.register(this.getWatcher(), thisCollection$iv.toArray(new WatchEvent.Kind[0]), new WatchEvent.Modifier[0]);
        Intrinsics.checkNotNull((Object)directory);
        watchedDirectoryThreads.put(directory, this.startWatcherThread(directory));
    }

    private final Thread startWatcherThread(Path directory) {
        Thread thread = new Thread(threadGroup, () -> FilesystemLoaderBackend.startWatcherThread$lambda$5(directory));
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    @Override
    public void unwatch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path file = Paths.get(path, new String[0]);
        Path directory = file.getParent();
        Integer n = watchedDirectoryPathCount.get(directory);
        int newDirectoryPathCount = n != null ? n - 1 : 0;
        Integer n2 = newDirectoryPathCount;
        watchedDirectoryPathCount.put(directory, n2);
        Thread thread = watchedDirectoryThreads.get(directory);
        if (thread != null) {
            Thread it = thread;
            boolean bl = false;
            if (it.isAlive() && newDirectoryPathCount == 0) {
                logger.info(() -> FilesystemLoaderBackend.unwatch$lambda$7$lambda$6(directory));
                it.interrupt();
                watchedDirectoryPathCount.remove(directory);
                watchedDirectoryThreads.remove(directory);
            }
        }
        watchedPaths.remove(file);
        resourceChangedListeners.remove(file);
    }

    private static final WatchService watcher_delegate$lambda$0() {
        return FileSystems.getDefault().newWatchService();
    }

    private static final Object watch$lambda$2(Path $directory) {
        return "Registering watcher on " + $directory;
    }

    private static final void startWatcherThread$lambda$5(Path $directory) {
        try {
            while (true) {
                Object v1;
                WatchKey key;
                block8: {
                    key = INSTANCE.getWatcher().take();
                    List<WatchEvent<?>> list = key.pollEvents();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"pollEvents(...)");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        WatchEvent event = (WatchEvent)element$iv;
                        boolean bl = false;
                        if (!CollectionsKt.contains((Iterable)watchedEventKinds, event.kind())) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                WatchEvent watchEvent = v1;
                if (watchEvent != null) {
                    WatchEvent event = watchEvent;
                    boolean bl = false;
                    WatchEvent ev = event;
                    Object t = ev.context();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"context(...)");
                    Path fileName = (Path)t;
                    Path fullPathFile = $directory.resolve(fileName);
                    if (watchedPaths.contains(fullPathFile)) {
                        String address = SCHEME + fullPathFile;
                        Function1<String, Unit> function1 = resourceChangedListeners.get(fullPathFile);
                        if (function1 != null) {
                            function1.invoke((Object)address);
                        }
                    }
                }
                key.reset();
            }
        }
        catch (InterruptedException key) {
        }
        catch (Exception e) {
            logger.warn("Problem while watching " + $directory, (Throwable)e);
        }
    }

    private static final Object unwatch$lambda$7$lambda$6(Path $directory) {
        return "Removing watcher on " + $directory;
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(FilesystemLoaderBackend.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
        watcher$delegate = LazyKt.lazy(FilesystemLoaderBackend::watcher_delegate$lambda$0);
        threadGroup = new ThreadGroup("FilesystemLoader");
        watchedDirectoryThreads = new LinkedHashMap();
        watchedDirectoryPathCount = new LinkedHashMap();
        watchedPaths = new LinkedHashSet();
        resourceChangedListeners = new LinkedHashMap();
        Object[] objectArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
        watchedEventKinds = CollectionsKt.listOf((Object[])objectArray);
    }
}

