/*
 * Decompiled with CFR 0.152.
 */
package wisp.resources;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.resources.ResourceLoader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lwisp/resources/EnvironmentResourceLoaderBackend;", "Lwisp/resources/ResourceLoader$Backend;", "<init>", "()V", "SCHEME", "", "list", "", "path", "open", "Lokio/BufferedSource;", "exists", "", "checkPath", "", "normalisedPath", "wisp-resource-loader"})
@SourceDebugExtension(value={"SMAP\nEnvironmentResourceLoaderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentResourceLoaderBackend.kt\nwisp/resources/EnvironmentResourceLoaderBackend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class EnvironmentResourceLoaderBackend
extends ResourceLoader.Backend {
    @NotNull
    public static final EnvironmentResourceLoaderBackend INSTANCE = new EnvironmentResourceLoaderBackend();
    @NotNull
    public static final String SCHEME = "environment:";

    private EnvironmentResourceLoaderBackend() {
    }

    @Override
    @NotNull
    public List<String> list(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!(!StringsKt.isBlank((CharSequence)path))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.listOf((Object)this.normalisedPath(path));
    }

    @Override
    @Nullable
    public BufferedSource open(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = System.getenv(this.normalisedPath(path));
        if (string == null) {
            return null;
        }
        String value = string;
        Buffer buffer = new Buffer();
        buffer.writeUtf8(value);
        return (BufferedSource)buffer;
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return System.getenv(this.normalisedPath(path)) != null;
    }

    @Override
    public void checkPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!(!StringsKt.isBlank((CharSequence)path))) {
            boolean bl = false;
            String string = "unexpected path " + path;
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final String normalisedPath(String path) {
        return ((Object)StringsKt.trim((CharSequence)path)).toString();
    }
}

