/*
 * Decompiled with CFR 0.152.
 */
package wisp.resources;

import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.resources.ClasspathResourceLoaderBackend;
import wisp.resources.FilesystemLoaderBackend;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 '2\u00020\u0001:\u0003%&'B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0004J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\t\u001a\u00020\u0004J1\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\b0\"R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lwisp/resources/ResourceLoader;", "", "backends", "", "", "Lwisp/resources/ResourceLoader$Backend;", "(Ljava/util/Map;)V", "checkAddress", "", "address", "copyResource", "destination", "Ljava/nio/file/Path;", "copyTo", "root", "dir", "exists", "", "list", "", "open", "Lokio/BufferedSource;", "parseAddress", "Lwisp/resources/ResourceLoader$Address;", "path", "put", "utf8", "data", "Lokio/ByteString;", "requireUtf8", "unwatch", "walk", "watch", "resourceChangedListener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Address", "Backend", "Companion", "wisp-resource-loader"})
@SourceDebugExtension(value={"SMAP\nResourceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceLoader.kt\nwisp/resources/ResourceLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1549#2:226\n1620#2,3:227\n1#3:230\n*S KotlinDebug\n*F\n+ 1 ResourceLoader.kt\nwisp/resources/ResourceLoader\n*L\n89#1:226\n89#1:227,3\n*E\n"})
public class ResourceLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Backend> backends;
    @NotNull
    private static final ResourceLoader SYSTEM;

    public ResourceLoader(@NotNull Map<String, ? extends Backend> backends) {
        Intrinsics.checkNotNullParameter(backends, (String)"backends");
        this.backends = backends;
        for (String prefix : this.backends.keySet()) {
            CharSequence charSequence = prefix;
            if (new Regex("[^/:]+:").matches(charSequence)) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final BufferedSource open(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.checkAddress(address);
        Address address2 = this.parseAddress(address);
        String scheme = address2.component1();
        String path = address2.component2();
        Backend backend = this.backends.get(scheme);
        if (backend == null) {
            return null;
        }
        Backend backend2 = backend;
        return backend2.open(path);
    }

    public final void put(@NotNull String address, @NotNull String utf8) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)utf8, (String)"utf8");
        this.put(address, ByteString.Companion.encodeUtf8(utf8));
    }

    public final void put(@NotNull String address, @NotNull ByteString data) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.checkAddress(address);
        Address address2 = this.parseAddress(address);
        String scheme = address2.component1();
        String path = address2.component2();
        Backend backend = this.backends.get(scheme);
        if (backend == null) {
            return;
        }
        Backend backend2 = backend;
        backend2.put(path, data);
    }

    public final boolean exists(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        try {
            this.checkAddress(address);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Address address2 = this.parseAddress(address);
        String scheme = address2.component1();
        String path = address2.component2();
        Backend backend = this.backends.get(scheme);
        if (backend == null) {
            return false;
        }
        Backend backend2 = backend;
        return backend2.exists(path);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> list(@NotNull String address) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        try {
            this.checkAddress(address);
        }
        catch (IllegalArgumentException e) {
            return CollectionsKt.emptyList();
        }
        Address address2 = this.parseAddress(address);
        String scheme = address2.component1();
        String path = address2.component2();
        Backend backend = this.backends.get(scheme);
        if (backend == null) {
            return CollectionsKt.emptyList();
        }
        Backend backend2 = backend;
        Iterable $this$map$iv = backend2.list(path);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(scheme + (String)it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> walk(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        List resourcesResult = new ArrayList();
        for (String resource : this.list(address)) {
            if (this.list(resource).isEmpty()) {
                resourcesResult.add(resource);
                continue;
            }
            resourcesResult.addAll((Collection)this.walk(resource));
        }
        List<String> list = Collections.unmodifiableList(resourcesResult);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String utf8(@NotNull String address) {
        String string;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        BufferedSource bufferedSource = this.open(address);
        if (bufferedSource == null) {
            return null;
        }
        BufferedSource source = bufferedSource;
        Closeable closeable = (Closeable)source;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            string = it.readUtf8();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @NotNull
    public final String requireUtf8(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String string = this.utf8(address);
        if (string == null) {
            throw new IllegalStateException(("could not load resource " + address).toString());
        }
        return string;
    }

    private final void checkAddress(String address) {
        CharSequence charSequence = address;
        if (!new Regex("([^/:]+:)(/[^/]+)+/?").matches(charSequence)) {
            boolean bl = false;
            String string = "unexpected address " + address;
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final Address parseAddress(String path) {
        int colon = StringsKt.indexOf$default((CharSequence)path, (char)':', (int)0, (boolean)false, (int)6, null);
        if (!(colon != -1)) {
            boolean bl = false;
            String string = "address scheme not specified in: " + path;
            throw new IllegalStateException(string.toString());
        }
        String string = path.substring(0, colon + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = path.substring(colon + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return new Address(string, string2);
    }

    public final void copyTo(@NotNull String root, @NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object prefix = StringsKt.endsWith$default((String)root, (String)"/", (boolean)false, (int)2, null) ? root : root + "/";
        for (String resource : this.walk(root)) {
            String string = resource.substring(((String)prefix).length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Path destination = dir.resolve(string);
            Intrinsics.checkNotNull((Object)destination);
            this.copyResource(resource, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyResource(String address, Path destination) {
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        Closeable closeable = (Closeable)this.open(address);
        Throwable throwable = null;
        try {
            long l;
            BufferedSource i = (BufferedSource)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)Okio.buffer((Sink)Okio.sink((Path)destination, (OpenOption[])new OpenOption[0]));
            Throwable throwable2 = null;
            try {
                BufferedSink o = (BufferedSink)closeable2;
                boolean bl2 = false;
                BufferedSource bufferedSource = i;
                Intrinsics.checkNotNull((Object)bufferedSource);
                l = o.writeAll((Source)bufferedSource);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void watch(@NotNull String address, @NotNull Function1<? super String, Unit> resourceChangedListener) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(resourceChangedListener, (String)"resourceChangedListener");
        this.checkAddress(address);
        Address address2 = this.parseAddress(address);
        String scheme = address2.component1();
        String path = address2.component2();
        Backend backend = this.backends.get(scheme);
        if (backend == null) {
            return;
        }
        Backend backend2 = backend;
        backend2.watch(path, resourceChangedListener);
    }

    public final void unwatch(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.checkAddress(address);
        Address address2 = this.parseAddress(address);
        String scheme = address2.component1();
        String path = address2.component2();
        Backend backend = this.backends.get(scheme);
        if (backend == null) {
            return;
        }
        Backend backend2 = backend;
        backend2.unwatch(path);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"classpath:", (Object)ClasspathResourceLoaderBackend.INSTANCE), TuplesKt.to((Object)"filesystem:", (Object)FilesystemLoaderBackend.INSTANCE)};
        SYSTEM = new ResourceLoader(MapsKt.mapOf((Pair[])pairArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lwisp/resources/ResourceLoader$Address;", "", "scheme", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getScheme", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "wisp-resource-loader"})
    private static final class Address {
        @NotNull
        private final String scheme;
        @NotNull
        private final String path;

        public Address(@NotNull String scheme, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.scheme = scheme;
            this.path = path;
        }

        @NotNull
        public final String getScheme() {
            return this.scheme;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String component1() {
            return this.scheme;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final Address copy(@NotNull String scheme, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new Address(scheme, path);
        }

        public static /* synthetic */ Address copy$default(Address address, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = address.scheme;
            }
            if ((n & 2) != 0) {
                string2 = address.path;
            }
            return address.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Address(scheme=" + this.scheme + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result = this.scheme.hashCode();
            result = result * 31 + this.path.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Address)) {
                return false;
            }
            Address address = (Address)other;
            if (!Intrinsics.areEqual((Object)this.scheme, (Object)address.scheme)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)address.path);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H&J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u0005H&J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005H\u0016J3\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016\u00a8\u0006\u0018"}, d2={"Lwisp/resources/ResourceLoader$Backend;", "", "()V", "all", "", "", "exists", "", "path", "list", "", "open", "Lokio/BufferedSource;", "put", "", "data", "Lokio/ByteString;", "unwatch", "watch", "resourceChangedListener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "address", "wisp-resource-loader"})
    public static abstract class Backend {
        @Nullable
        public abstract BufferedSource open(@NotNull String var1);

        public abstract boolean exists(@NotNull String var1);

        public void put(@NotNull String path, @NotNull ByteString data) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            throw new UnsupportedOperationException("cannot put " + path + "; " + Reflection.getOrCreateKotlinClass(this.getClass()) + " is readonly");
        }

        @NotNull
        public Set<String> all() {
            throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.getClass()) + " doesn't support all()");
        }

        @NotNull
        public List<String> list(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object prefix = StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) ? path : path + "/";
            Set result = new LinkedHashSet();
            for (String key : this.all()) {
                if (!StringsKt.startsWith$default((String)key, (String)prefix, (boolean)false, (int)2, null)) continue;
                int slash = StringsKt.indexOf$default((CharSequence)key, (char)'/', (int)((String)prefix).length(), (boolean)false, (int)4, null);
                if (slash == -1) {
                    result.add(key);
                    continue;
                }
                String string = key.substring(0, slash);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.add(string);
            }
            List<String> list = Collections.unmodifiableList(CollectionsKt.toList((Iterable)result));
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }

        public void watch(@NotNull String path, @NotNull Function1<? super String, Unit> resourceChangedListener) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(resourceChangedListener, (String)"resourceChangedListener");
            throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.getClass()) + " doesn't support watch");
        }

        public void unwatch(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.getClass()) + " doesn't support unwatch");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lwisp/resources/ResourceLoader$Companion;", "", "()V", "SYSTEM", "Lwisp/resources/ResourceLoader;", "getSYSTEM", "()Lwisp/resources/ResourceLoader;", "wisp-resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLoader getSYSTEM() {
            return SYSTEM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

