/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.filter;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import org.hypertrace.agent.filter.api.Filter;

class MultiFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(MultiFilter.class);
    private final List<Filter> filters;

    public MultiFilter(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean evaluateRequestHeaders(Span span, Map<String, String> headers) {
        boolean shouldBlock = false;
        for (Filter filter : this.filters) {
            try {
                if (!filter.evaluateRequestHeaders(span, headers)) continue;
                shouldBlock = true;
            }
            catch (Throwable t) {
                logger.warn("Throwable thrown while evaluating Request headers for filter {}", (Object)filter.getClass().getName(), (Object)t);
            }
        }
        return shouldBlock;
    }

    @Override
    public boolean evaluateRequestBody(Span span, String body, Map<String, String> headers) {
        boolean shouldBlock = false;
        for (Filter filter : this.filters) {
            try {
                if (!filter.evaluateRequestBody(span, body, headers)) continue;
                shouldBlock = true;
            }
            catch (Throwable t) {
                logger.warn("Throwable thrown while evaluating Request body for filter {}", (Object)filter.getClass().getName(), (Object)t);
            }
        }
        return shouldBlock;
    }
}

