/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.filter;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.hypertrace.agent.filter.MultiFilter;
import org.hypertrace.agent.filter.api.Filter;
import org.hypertrace.agent.filter.spi.FilterProvider;

public class FilterRegistry {
    private static final Logger logger = LoggerFactory.getLogger(FilterRegistry.class);
    private static Filter filter;

    private FilterRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Filter getFilter() {
        if (filter != null) return filter;
        Class<FilterRegistry> clazz = FilterRegistry.class;
        synchronized (FilterRegistry.class) {
            if (filter != null) return filter;
            try {
                filter = FilterRegistry.load(Collections.emptyList());
            }
            catch (Throwable t) {
                logger.error("Throwable thrown while loading filter jars", t);
            }
            return filter;
        }
    }

    public static void initialize(List<String> jarPaths) {
        try {
            filter = FilterRegistry.load(jarPaths);
        }
        catch (Throwable t) {
            logger.error("Throwable thrown while loading filter jars", t);
        }
    }

    private static Filter load(List<String> jarPaths) {
        ClassLoader cl = FilterRegistry.loadJars(jarPaths);
        ServiceLoader<FilterProvider> providers = ServiceLoader.load(FilterProvider.class, cl);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (FilterProvider provider : providers) {
            String disabled = FilterRegistry.getProperty(FilterRegistry.getProviderDisabledPropertyName(provider.getClass()));
            if ("true".equalsIgnoreCase(disabled)) continue;
            Filter filter = provider.create();
            filters.add(filter);
        }
        return new MultiFilter(filters);
    }

    private static ClassLoader loadJars(List<String> jarPaths) {
        URL[] urls = new URL[jarPaths.size()];
        int i = 0;
        for (String jarPath : jarPaths) {
            try {
                URL url;
                urls[i] = url = new URL("file", "", -1, jarPath);
                ++i;
            }
            catch (MalformedURLException e) {
                logger.warn(String.format("Malformed URL exception for jar on path: %s", jarPath), e);
            }
        }
        return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public static String getProviderDisabledPropertyName(Class<?> clazz) {
        return String.format("ht.filter.provider.%s.disabled", clazz.getSimpleName());
    }

    public static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name.replaceAll("\\.", "_").toUpperCase()));
    }
}

