/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.buffer;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import java.util.Map;
import org.hypertrace.agent.core.TriFunction;
import org.hypertrace.agent.core.instrumentation.HypertraceEvaluationException;
import org.hypertrace.agent.core.instrumentation.buffer.BoundedCharArrayWriter;

public class CharBufferSpanPair {
    public final Span span;
    public final Map<String, String> headers;
    public final BoundedCharArrayWriter buffer;
    private final TriFunction<Span, String, Map<String, String>, Boolean> filter;
    private boolean bufferCaptured;

    public CharBufferSpanPair(Span span, BoundedCharArrayWriter buffer, TriFunction<Span, String, Map<String, String>, Boolean> filter, Map<String, String> headers) {
        this.span = span;
        this.buffer = buffer;
        this.headers = headers;
        this.filter = filter;
    }

    public void captureBody(AttributeKey<String> attributeKey) {
        if (this.bufferCaptured) {
            return;
        }
        this.bufferCaptured = true;
        String requestBody = this.buffer.toString();
        this.span.setAttribute(attributeKey, requestBody);
        boolean block = this.filter.apply(this.span, requestBody, this.headers);
        if (block) {
            throw new HypertraceEvaluationException();
        }
    }
}

