/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.buffer;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import org.hypertrace.agent.core.TriFunction;
import org.hypertrace.agent.core.instrumentation.HypertraceEvaluationException;
import org.hypertrace.agent.core.instrumentation.buffer.BoundedByteArrayOutputStream;

public class ByteBufferSpanPair {
    public final Span span;
    public final BoundedByteArrayOutputStream buffer;
    private final Map<String, String> headers;
    private boolean bufferCaptured;
    private final TriFunction<Span, String, Map<String, String>, Boolean> filter;

    public ByteBufferSpanPair(Span span, BoundedByteArrayOutputStream buffer, TriFunction<Span, String, Map<String, String>, Boolean> filter, Map<String, String> headers) {
        this.span = span;
        this.buffer = buffer;
        this.filter = Objects.requireNonNull(filter);
        this.headers = headers;
    }

    public void captureBody(AttributeKey<String> attributeKey) {
        if (this.bufferCaptured) {
            return;
        }
        this.bufferCaptured = true;
        String requestBody = null;
        try {
            requestBody = this.buffer.toStringWithSuppliedCharset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.span.setAttribute(attributeKey, requestBody);
        boolean block = this.filter.apply(this.span, requestBody, this.headers);
        if (block) {
            throw new HypertraceEvaluationException();
        }
    }
}

