/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.RpcAttributesExtractor;

public final class RpcSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final RpcAttributesExtractor<REQUEST, ?> attributesExtractor;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(RpcAttributesExtractor<REQUEST, ?> attributesExtractor) {
        return new RpcSpanNameExtractor<REQUEST>(attributesExtractor);
    }

    private RpcSpanNameExtractor(RpcAttributesExtractor<REQUEST, ?> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public String extract(REQUEST request) {
        String service = this.attributesExtractor.service(request);
        String method = this.attributesExtractor.method(request);
        if (service == null || method == null) {
            return "RPC request";
        }
        return service + '/' + method;
    }
}

