/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpHeaderAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import javax.annotation.Nullable;

abstract class HttpCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends HttpCommonAttributesGetter<REQUEST, RESPONSE>>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final GETTER getter;
    private final CapturedHttpHeaders capturedHttpHeaders;

    HttpCommonAttributesExtractor(GETTER getter, CapturedHttpHeaders capturedHttpHeaders) {
        this.getter = getter;
        this.capturedHttpHeaders = capturedHttpHeaders;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        this.set(attributes, SemanticAttributes.HTTP_METHOD, this.getter.method(request));
        this.set(attributes, SemanticAttributes.HTTP_USER_AGENT, this.userAgent(request));
        for (String name : this.capturedHttpHeaders.requestHeaders()) {
            List<String> values = this.getter.requestHeader(request, name);
            if (values.isEmpty()) continue;
            this.set(attributes, HttpHeaderAttributes.requestAttributeKey(name), values);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.set(attributes, SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, this.getter.requestContentLength(request, response));
        this.set(attributes, SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED, this.getter.requestContentLengthUncompressed(request, response));
        if (response != null) {
            Integer statusCode = this.getter.statusCode(request, response);
            if (statusCode != null && statusCode > 0) {
                this.set(attributes, SemanticAttributes.HTTP_STATUS_CODE, Long.valueOf(statusCode.intValue()));
            }
            this.set(attributes, SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, this.getter.responseContentLength(request, response));
            this.set(attributes, SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED, this.getter.responseContentLengthUncompressed(request, response));
            for (String name : this.capturedHttpHeaders.responseHeaders()) {
                List<String> values = this.getter.responseHeader(request, response, name);
                if (values.isEmpty()) continue;
                this.set(attributes, HttpHeaderAttributes.responseAttributeKey(name), values);
            }
        }
    }

    @Nullable
    private String userAgent(REQUEST request) {
        return HttpCommonAttributesExtractor.firstHeaderValue(this.getter.requestHeader(request, "user-agent"));
    }

    @Nullable
    static String firstHeaderValue(List<String> values) {
        return values.isEmpty() ? null : values.get(0);
    }
}

