/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;

final class CompositeSuppressionStrategy
extends SpanSuppressionStrategy {
    private final SpanSuppressionStrategy clientStrategy;
    private final SpanSuppressionStrategy producerStrategy;
    private final SpanSuppressionStrategy serverStrategy;
    private final SpanSuppressionStrategy consumerStrategy;

    CompositeSuppressionStrategy(SpanSuppressionStrategy client, SpanSuppressionStrategy producer, SpanSuppressionStrategy server, SpanSuppressionStrategy consumer) {
        this.clientStrategy = client;
        this.producerStrategy = producer;
        this.serverStrategy = server;
        this.consumerStrategy = consumer;
    }

    @Override
    Context storeInContext(Context context, SpanKind spanKind, Span span) {
        switch (spanKind) {
            case CLIENT: {
                return this.clientStrategy.storeInContext(context, spanKind, span);
            }
            case PRODUCER: {
                return this.producerStrategy.storeInContext(context, spanKind, span);
            }
            case SERVER: {
                return this.serverStrategy.storeInContext(context, spanKind, span);
            }
            case CONSUMER: {
                return this.consumerStrategy.storeInContext(context, spanKind, span);
            }
            case INTERNAL: {
                return context;
            }
        }
        return context;
    }

    @Override
    boolean shouldSuppress(Context parentContext, SpanKind spanKind) {
        switch (spanKind) {
            case CLIENT: {
                return this.clientStrategy.shouldSuppress(parentContext, spanKind);
            }
            case PRODUCER: {
                return this.producerStrategy.shouldSuppress(parentContext, spanKind);
            }
            case SERVER: {
                return this.serverStrategy.shouldSuppress(parentContext, spanKind);
            }
            case CONSUMER: {
                return this.consumerStrategy.shouldSuppress(parentContext, spanKind);
            }
            case INTERNAL: {
                return false;
            }
        }
        return false;
    }
}

