/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.db;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.cache.Cache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.AutoSqlSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.AutoValue_SqlStatementSanitizer_CacheKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlDialect;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.StatementSanitizationConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import javax.annotation.Nullable;

public final class SqlStatementSanitizer {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private static final Cache<CacheKey, SqlStatementInfo> sqlToStatementInfoCache = Cache.bounded(1000);

    public static SqlStatementInfo sanitize(@Nullable String statement) {
        return SqlStatementSanitizer.sanitize(statement, SqlDialect.DEFAULT);
    }

    public static SqlStatementInfo sanitize(@Nullable String statement, SqlDialect dialect) {
        if (!StatementSanitizationConfig.isStatementSanitizationEnabled() || statement == null) {
            return SqlStatementInfo.create(statement, null, null);
        }
        return sqlToStatementInfoCache.computeIfAbsent(CacheKey.create(statement, dialect), k -> {
            supportability.incrementCounter("SqlStatementSanitizer cache miss");
            return AutoSqlSanitizer.sanitize(statement, dialect);
        });
    }

    private SqlStatementSanitizer() {
    }

    @AutoValue
    static abstract class CacheKey {
        CacheKey() {
        }

        static CacheKey create(String statement, SqlDialect dialect) {
            return new AutoValue_SqlStatementSanitizer_CacheKey(statement, dialect);
        }

        abstract String getStatement();

        abstract SqlDialect getDialect();
    }
}

