/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model.service.engine;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.EntityContextKey;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.ModelNotInitializedException;
import ai.tock.nlp.model.TokenizerContext;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelIo;
import ai.tock.nlp.model.service.engine.NlpEngineProvider;
import ai.tock.nlp.model.service.engine.NlpEngineRepository;
import ai.tock.nlp.model.service.engine.TokenizerModelHolder;
import ai.tock.nlp.model.service.storage.NlpEngineModelDAO;
import ai.tock.nlp.model.service.storage.NlpModelStream;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001AB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010#\u001a\u00020\u001c*\u00020 2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0019\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010)\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J:\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020+0-2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020+0-2\b\b\u0002\u00101\u001a\u000202H\u0002J\u001e\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\"2\u0006\u00106\u001a\u000207J\u001e\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u00162\u0006\u00105\u001a\u00020(2\u0006\u00106\u001a\u000207J\u000e\u0010:\u001a\u0002022\u0006\u0010\u0019\u001a\u00020\u001eJ\u000e\u0010;\u001a\u0002022\u0006\u0010\u0019\u001a\u00020<J\u0014\u0010=\u001a\u00020+2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00160?J\u0014\u0010@\u001a\u00020+2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00130?R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lai/tock/nlp/model/service/engine/NlpModelRepository;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "modelDAO", "Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;", "getModelDAO", "()Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;", "modelDAO$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "intentModelsCache", "Lcom/google/common/cache/Cache;", "Lai/tock/nlp/model/IntentContext$IntentContextKey;", "Lai/tock/nlp/model/service/engine/NlpModelRepository$ConfiguredModel;", "entityModelsCache", "Lai/tock/nlp/model/EntityContextKey;", "getTokenizerModelHolder", "Lai/tock/nlp/model/service/engine/TokenizerModelHolder;", "context", "Lai/tock/nlp/model/TokenizerContext;", "conf", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "getConfiguration", "Lai/tock/nlp/model/IntentContext;", "provider", "Lai/tock/nlp/model/service/engine/NlpEngineProvider;", "getIntentModelHolder", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "configuration", "loadIntentModel", "contextKey", "Lai/tock/nlp/model/EntityContext;", "getEntityModelHolder", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "loadEntityModel", "saveModel", "", "copy", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "save", "Ljava/io/InputStream;", "retry", "", "saveIntentModel", "intentContextKey", "model", "modelIo", "Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "saveEntityModel", "entityContextKey", "isIntentModelExist", "isEntityModelExist", "Lai/tock/nlp/model/EntityBuildContext;", "removeEntityModelsNotIn", "keys", "", "removeIntentModelsNotIn", "ConfiguredModel", "tock-nlp-model-service"})
@SourceDebugExtension(value={"SMAP\nNlpModelRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlpModelRepository.kt\nai/tock/nlp/model/service/engine/NlpModelRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,253:1\n1#2:254\n80#3:255\n277#4:256\n*S KotlinDebug\n*F\n+ 1 NlpModelRepository.kt\nai/tock/nlp/model/service/engine/NlpModelRepository\n*L\n-1#1:255\n-1#1:256\n*E\n"})
public final class NlpModelRepository {
    @NotNull
    public static final NlpModelRepository INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final InjectedProperty modelDAO$delegate;
    @NotNull
    private static final InjectedProperty executor$delegate;
    @NotNull
    private static final Cache<IntentContext.IntentContextKey, ConfiguredModel> intentModelsCache;
    @NotNull
    private static final Cache<EntityContextKey, ConfiguredModel> entityModelsCache;

    private NlpModelRepository() {
    }

    private final NlpEngineModelDAO getModelDAO() {
        return (NlpEngineModelDAO)modelDAO$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final Executor getExecutor() {
        return (Executor)executor$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @NotNull
    public final TokenizerModelHolder getTokenizerModelHolder(@NotNull TokenizerContext context, @NotNull NlpApplicationConfiguration conf) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return new TokenizerModelHolder(context.getLanguage(), conf);
    }

    @NotNull
    public final NlpApplicationConfiguration getConfiguration(@NotNull IntentContext context, @NotNull NlpEngineProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        return this.getIntentModelHolder(context, provider2).getConfiguration();
    }

    @NotNull
    public final IntentModelHolder getIntentModelHolder(@NotNull IntentContext context, @NotNull NlpEngineProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        IntentContext.IntentContextKey key = context.key();
        boolean bl = false;
        ConfiguredModel it = (ConfiguredModel)intentModelsCache.get((Object)key, () -> NlpModelRepository.getIntentModelHolder$lambda$0$0(key, provider2));
        boolean bl2 = false;
        Application application = context.getApplication();
        Object object = it.getNativeModel();
        Intrinsics.checkNotNull((Object)object);
        return new IntentModelHolder(application, object, it.getConfiguration(), it.getLastUpdate());
    }

    private final NlpApplicationConfiguration configuration(NlpEngineProvider $this$configuration, NlpApplicationConfiguration configuration) {
        NlpApplicationConfiguration nlpApplicationConfiguration = configuration;
        if (nlpApplicationConfiguration == null) {
            nlpApplicationConfiguration = $this$configuration.getModelBuilder().defaultNlpApplicationConfiguration();
        }
        return nlpApplicationConfiguration;
    }

    static /* synthetic */ NlpApplicationConfiguration configuration$default(NlpModelRepository nlpModelRepository, NlpEngineProvider nlpEngineProvider, NlpApplicationConfiguration nlpApplicationConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            nlpApplicationConfiguration = null;
        }
        return nlpModelRepository.configuration(nlpEngineProvider, nlpApplicationConfiguration);
    }

    private final ConfiguredModel loadIntentModel(IntentContext.IntentContextKey contextKey, NlpEngineProvider provider2) {
        NlpModelStream inputStream = this.getModelDAO().getIntentModelInputStream(contextKey);
        if (inputStream != null) {
            logger.debug(() -> NlpModelRepository.loadIntentModel$lambda$0(contextKey));
            Object model = provider2.getModelIo().loadIntentModel(inputStream);
            return new ConfiguredModel(model, inputStream.getUpdatedDate(), this.configuration(provider2, inputStream.getConfiguration()));
        }
        throw new ModelNotInitializedException("no intent model found for " + contextKey);
    }

    @NotNull
    public final NlpApplicationConfiguration getConfiguration(@NotNull EntityContext context, @NotNull NlpEngineProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        EntityModelHolder entityModelHolder = this.getEntityModelHolder(context, provider2);
        if (entityModelHolder == null || (entityModelHolder = entityModelHolder.getConfiguration()) == null) {
            entityModelHolder = provider2.getModelBuilder().defaultNlpApplicationConfiguration();
        }
        return entityModelHolder;
    }

    @Nullable
    public final EntityModelHolder getEntityModelHolder(@NotNull EntityContext context, @NotNull NlpEngineProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        EntityContextKey it = (EntityContextKey)context.key();
        boolean bl = false;
        ConfiguredModel configuredModel = (ConfiguredModel)entityModelsCache.get((Object)it, () -> NlpModelRepository.getEntityModelHolder$lambda$0$0(it, provider2));
        boolean bl2 = false;
        Object nativeModel = configuredModel.component1();
        Instant lastUpdate = configuredModel.component2();
        NlpApplicationConfiguration conf = configuredModel.component3();
        return nativeModel == null ? null : new EntityModelHolder(nativeModel, conf, lastUpdate);
    }

    private final ConfiguredModel loadEntityModel(EntityContextKey contextKey, NlpEngineProvider provider2) {
        NlpModelStream nlpModelStream = this.getModelDAO().getEntityModelInputStream(contextKey);
        if (nlpModelStream != null) {
            NlpModelStream inputStream = nlpModelStream;
            boolean bl = false;
            logger.debug(() -> NlpModelRepository.loadEntityModel$lambda$0$0(contextKey));
            Object model = provider2.getModelIo().loadEntityModel(inputStream);
            return new ConfiguredModel(model, inputStream.getUpdatedDate(), INSTANCE.configuration(provider2, inputStream.getConfiguration()));
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new ConfiguredModel(null, instant, NlpModelRepository.configuration$default(this, provider2, null, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveModel(Function1<? super OutputStream, Unit> copy, Function1<? super InputStream, Unit> save, boolean retry) {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        CountDownLatch latch = new CountDownLatch(1);
        this.getExecutor().executeBlocking(() -> NlpModelRepository.saveModel$lambda$0(pipedOutputStream, latch, copy));
        Closeable closeable = pipedInputStream;
        Throwable throwable = null;
        try {
            block11: {
                PipedInputStream it = (PipedInputStream)closeable;
                boolean bl = false;
                try {
                    logger.debug(NlpModelRepository::saveModel$lambda$1$0);
                    save.invoke((Object)it);
                }
                catch (Exception e) {
                    LoggersKt.debug((KLogger)logger, (Throwable)e);
                    if (retry) {
                        INSTANCE.saveModel(copy, save, false);
                        break block11;
                    }
                    throw e;
                }
                finally {
                    logger.debug(NlpModelRepository::saveModel$lambda$1$1);
                    latch.countDown();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void saveModel$default(NlpModelRepository nlpModelRepository, Function1 function1, Function1 function12, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        nlpModelRepository.saveModel((Function1<? super OutputStream, Unit>)function1, (Function1<? super InputStream, Unit>)function12, bl);
    }

    public final void saveIntentModel(@NotNull IntentContext.IntentContextKey intentContextKey, @NotNull IntentModelHolder model, @NotNull NlpEngineModelIo modelIo) {
        Intrinsics.checkNotNullParameter((Object)intentContextKey, (String)"intentContextKey");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)modelIo, (String)"modelIo");
        NlpModelRepository.saveModel$default(this, arg_0 -> NlpModelRepository.saveIntentModel$lambda$0(modelIo, model, arg_0), arg_0 -> NlpModelRepository.saveIntentModel$lambda$1(intentContextKey, arg_0), false, 4, null);
    }

    public final void saveEntityModel(@NotNull EntityContextKey entityContextKey, @NotNull EntityModelHolder model, @NotNull NlpEngineModelIo modelIo) {
        Intrinsics.checkNotNullParameter((Object)entityContextKey, (String)"entityContextKey");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)modelIo, (String)"modelIo");
        NlpModelRepository.saveModel$default(this, arg_0 -> NlpModelRepository.saveEntityModel$lambda$0(modelIo, model, arg_0), arg_0 -> NlpModelRepository.saveEntityModel$lambda$1(entityContextKey, arg_0), false, 4, null);
    }

    public final boolean isIntentModelExist(@NotNull IntentContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getModelDAO().getIntentModelLastUpdate(context.key()) != null;
    }

    public final boolean isEntityModelExist(@NotNull EntityBuildContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getModelDAO().getEntityModelLastUpdate((EntityContextKey)context.key()) != null;
    }

    public final void removeEntityModelsNotIn(@NotNull List<EntityContextKey> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.getModelDAO().deleteEntityModelsNotIn(keys);
    }

    public final void removeIntentModelsNotIn(@NotNull List<IntentContext.IntentContextKey> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.getModelDAO().deleteIntentModelsNotIn(keys);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(String key) {
        block2: {
            IntentContext.IntentContextKey intentContextKey;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Iterable iterable = intentModelsCache.asMap().keySet();
                for (Object t : iterable) {
                    IntentContext.IntentContextKey it = (IntentContext.IntentContextKey)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.id(), (Object)key)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            IntentContext.IntentContextKey intentContextKey2 = v0;
            if (intentContextKey2 == null) break block2;
            IntentContext.IntentContextKey it = intentContextKey = intentContextKey2;
            boolean bl = false;
            logger.info(() -> NlpModelRepository.lambda$0$1$0(key));
            intentModelsCache.put((Object)it, (Object)INSTANCE.loadIntentModel(it, NlpEngineRepository.INSTANCE.getProvider$tock_nlp_model_service(it.getEngineType())));
        }
        return Unit.INSTANCE;
    }

    private static final Object lambda$0$1$0(String $key) {
        return "refresh intent model for " + $key;
    }

    private static final Unit _init_$lambda$1(String key) {
        block2: {
            EntityContextKey entityContextKey;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Iterable iterable = entityModelsCache.asMap().keySet();
                for (Object t : iterable) {
                    EntityContextKey it = (EntityContextKey)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.id(), (Object)key)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            EntityContextKey entityContextKey2 = v0;
            if (entityContextKey2 == null) break block2;
            EntityContextKey it = entityContextKey = entityContextKey2;
            boolean bl = false;
            logger.info(() -> NlpModelRepository.lambda$1$1$0(key));
            entityModelsCache.put((Object)it, (Object)INSTANCE.loadEntityModel(it, NlpEngineRepository.INSTANCE.getProvider$tock_nlp_model_service(it.getEngineType())));
        }
        return Unit.INSTANCE;
    }

    private static final Object lambda$1$1$0(String $key) {
        return "refresh entity model for " + $key;
    }

    private static final Object _init_$lambda$2() {
        return "refresh model is disabled";
    }

    private static final ConfiguredModel getIntentModelHolder$lambda$0$0(IntentContext.IntentContextKey $key, NlpEngineProvider $provider) {
        return INSTANCE.loadIntentModel($key, $provider);
    }

    private static final Object loadIntentModel$lambda$0(IntentContext.IntentContextKey $contextKey) {
        return "load intent model for " + $contextKey;
    }

    private static final ConfiguredModel getEntityModelHolder$lambda$0$0(EntityContextKey $it, NlpEngineProvider $provider) {
        return INSTANCE.loadEntityModel($it, $provider);
    }

    private static final Object loadEntityModel$lambda$0$0(EntityContextKey $contextKey) {
        return "load entity model for " + $contextKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit saveModel$lambda$0(PipedOutputStream $pipedOutputStream, CountDownLatch $latch, Function1 $copy) {
        Closeable closeable = $pipedOutputStream;
        Throwable throwable = null;
        try {
            PipedOutputStream it = (PipedOutputStream)closeable;
            boolean bl = false;
            try {
                logger.debug(NlpModelRepository::saveModel$lambda$0$0$0);
                $copy.invoke((Object)it);
            }
            catch (Throwable t) {
                if ($latch.getCount() == 0L) {
                    LoggersKt.debug((KLogger)logger, (Throwable)t);
                } else {
                    LoggersKt.error((KLogger)logger, (Throwable)t);
                }
            }
            finally {
                logger.debug(NlpModelRepository::saveModel$lambda$0$0$1);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        $latch.await(1L, TimeUnit.MINUTES);
        logger.debug(NlpModelRepository::saveModel$lambda$0$1);
        return Unit.INSTANCE;
    }

    private static final Object saveModel$lambda$0$0$0() {
        return "Start copy model";
    }

    private static final Object saveModel$lambda$0$0$1() {
        return "Copy model end";
    }

    private static final Object saveModel$lambda$0$1() {
        return "latch release";
    }

    private static final Object saveModel$lambda$1$0() {
        return "Start to save the model";
    }

    private static final Object saveModel$lambda$1$1() {
        return "End persisting model";
    }

    private static final Unit saveIntentModel$lambda$0(NlpEngineModelIo $modelIo, IntentModelHolder $model, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $modelIo.copyIntentModel($model.getNativeModel(), it);
        return Unit.INSTANCE;
    }

    private static final Unit saveIntentModel$lambda$1(IntentContext.IntentContextKey $intentContextKey, InputStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.getModelDAO().saveIntentModel($intentContextKey, it);
        return Unit.INSTANCE;
    }

    private static final Unit saveEntityModel$lambda$0(NlpEngineModelIo $modelIo, EntityModelHolder $model, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $modelIo.copyEntityModel($model.getNativeModel(), it);
        return Unit.INSTANCE;
    }

    private static final Unit saveEntityModel$lambda$1(EntityContextKey $entityContextKey, InputStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.getModelDAO().saveEntityModel($entityContextKey, it);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NlpModelRepository.class, "modelDAO", "getModelDAO()Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NlpModelRepository.class, "executor", "getExecutor()Lai/tock/shared/Executor;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new NlpModelRepository();
        logger = KotlinLogging.INSTANCE.logger(NlpModelRepository::logger$lambda$0);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        modelDAO$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<NlpEngineModelDAO>(){}, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        executor$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Executor>(){}, tag$iv);
        Cache cache = CacheBuilder.newBuilder().softValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        intentModelsCache = cache;
        Cache cache2 = CacheBuilder.newBuilder().softValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        entityModelsCache = cache2;
        if (PropertiesKt.booleanProperty((String)"tock_nlp_model_refresh", (boolean)true)) {
            INSTANCE.getModelDAO().listenIntentModelChanges((Function1<? super String, Unit>)((Function1)NlpModelRepository::_init_$lambda$0));
            INSTANCE.getModelDAO().listenEntityModelChanges((Function1<? super String, Unit>)((Function1)NlpModelRepository::_init_$lambda$1));
        } else {
            logger.info(NlpModelRepository::_init_$lambda$2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/model/service/engine/NlpModelRepository$ConfiguredModel;", "", "nativeModel", "lastUpdate", "Ljava/time/Instant;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "<init>", "(Ljava/lang/Object;Ljava/time/Instant;Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;)V", "getNativeModel", "()Ljava/lang/Object;", "getLastUpdate", "()Ljava/time/Instant;", "getConfiguration", "()Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-model-service"})
    private static final class ConfiguredModel {
        @Nullable
        private final Object nativeModel;
        @NotNull
        private final Instant lastUpdate;
        @NotNull
        private final NlpApplicationConfiguration configuration;

        public ConfiguredModel(@Nullable Object nativeModel, @NotNull Instant lastUpdate, @NotNull NlpApplicationConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)lastUpdate, (String)"lastUpdate");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.nativeModel = nativeModel;
            this.lastUpdate = lastUpdate;
            this.configuration = configuration;
        }

        @Nullable
        public final Object getNativeModel() {
            return this.nativeModel;
        }

        @NotNull
        public final Instant getLastUpdate() {
            return this.lastUpdate;
        }

        @NotNull
        public final NlpApplicationConfiguration getConfiguration() {
            return this.configuration;
        }

        @Nullable
        public final Object component1() {
            return this.nativeModel;
        }

        @NotNull
        public final Instant component2() {
            return this.lastUpdate;
        }

        @NotNull
        public final NlpApplicationConfiguration component3() {
            return this.configuration;
        }

        @NotNull
        public final ConfiguredModel copy(@Nullable Object nativeModel, @NotNull Instant lastUpdate, @NotNull NlpApplicationConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)lastUpdate, (String)"lastUpdate");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new ConfiguredModel(nativeModel, lastUpdate, configuration);
        }

        public static /* synthetic */ ConfiguredModel copy$default(ConfiguredModel configuredModel, Object object, Instant instant, NlpApplicationConfiguration nlpApplicationConfiguration, int n, Object object2) {
            if ((n & 1) != 0) {
                object = configuredModel.nativeModel;
            }
            if ((n & 2) != 0) {
                instant = configuredModel.lastUpdate;
            }
            if ((n & 4) != 0) {
                nlpApplicationConfiguration = configuredModel.configuration;
            }
            return configuredModel.copy(object, instant, nlpApplicationConfiguration);
        }

        @NotNull
        public String toString() {
            return "ConfiguredModel(nativeModel=" + this.nativeModel + ", lastUpdate=" + this.lastUpdate + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            int result = this.nativeModel == null ? 0 : this.nativeModel.hashCode();
            result = result * 31 + this.lastUpdate.hashCode();
            result = result * 31 + this.configuration.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfiguredModel)) {
                return false;
            }
            ConfiguredModel configuredModel = (ConfiguredModel)other;
            if (!Intrinsics.areEqual((Object)this.nativeModel, (Object)configuredModel.nativeModel)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastUpdate, (Object)configuredModel.lastUpdate)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configuration, (Object)configuredModel.configuration);
        }
    }
}

