/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.rasa;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.sample.SampleEntity;
import ai.tock.nlp.core.sample.SampleExpression;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.rasa.RasaConfigurationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\f\u0010\u000e\u001a\u00020\u0007*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/tock/nlp/rasa/RasaMarkdown;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "toModelDomainMarkdown", "", "context", "Lai/tock/nlp/model/IntentContext;", "toModelNluMarkdown", "expressions", "", "Lai/tock/nlp/core/sample/SampleExpression;", "rasaClassifiedFormat", "tock-nlp-model-rasa"})
@SourceDebugExtension(value={"SMAP\nRasaMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasaMarkdown.kt\nai/tock/nlp/rasa/RasaMarkdown\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,67:1\n1374#2:68\n1460#2,5:69\n1669#2,8:74\n1491#2:82\n1516#2,3:83\n1519#2,3:93\n1068#2:100\n1869#2,2:101\n1669#2,8:103\n382#3,7:86\n126#4:96\n153#4,3:97\n*S KotlinDebug\n*F\n+ 1 RasaMarkdown.kt\nai/tock/nlp/rasa/RasaMarkdown\n*L\n38#1:68\n38#1:69,5\n38#1:74,8\n46#1:82\n46#1:83,3\n46#1:93,3\n57#1:100\n57#1:101,2\n34#1:103,8\n46#1:86,7\n46#1:96\n46#1:97,3\n*E\n"})
public final class RasaMarkdown {
    @NotNull
    public static final RasaMarkdown INSTANCE = new RasaMarkdown();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(RasaMarkdown::logger$lambda$0);

    private RasaMarkdown() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toModelDomainMarkdown(@NotNull IntentContext context) {
        void it;
        void $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplication().getIntents();
        String string = CollectionsKt.joinToString$default((Iterable)context.getApplication().getIntents(), (CharSequence)"\n", null, null, (int)0, null, RasaMarkdown::toModelDomainMarkdown$lambda$0, (int)30, null);
        boolean $i$f$flatMap = false;
        void var4_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Intent it2 = (Intent)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getEntities();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy22 = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Entity it3 = (Entity)e$iv;
            boolean bl = false;
            String key$iv = it3.getEntityType().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Object $i$f$distinctBy22 = object = CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)"\n", null, (CharSequence)"\n\n", (int)0, null, RasaMarkdown::toModelDomainMarkdown$lambda$3, (int)26, null);
        boolean bl = false;
        logger.debug(() -> RasaMarkdown.toModelDomainMarkdown$lambda$4$0((String)it));
        return "intents:\n" + string + "\n\nentities:\n" + object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toModelNluMarkdown(@NotNull List<SampleExpression> expressions) {
        String string;
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Iterable $this$groupBy$iv = expressions;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv = iterator.next();
            SampleExpression it = (SampleExpression)element$iv$iv;
            boolean bl = false;
            Intent key$iv$iv = it.getIntent();
            Map map = destination$iv$iv;
            Intent key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            Intent intent = (Intent)entry.getKey();
            List sentences = (List)entry.getValue();
            object.add("## intent:" + RasaConfigurationKt.escapeRasaName(intent.getName()) + "\n" + CollectionsKt.joinToString$default((Iterable)sentences, (CharSequence)"\n", null, null, (int)0, null, RasaMarkdown::toModelNluMarkdown$lambda$1$0, (int)30, null));
        }
        String it = string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n\n", null, (CharSequence)"\n\n", (int)0, null, null, (int)58, null);
        boolean bl = false;
        logger.debug(() -> RasaMarkdown.toModelNluMarkdown$lambda$2$0(it));
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String rasaClassifiedFormat(SampleExpression $this$rasaClassifiedFormat) {
        void $this$forEach$iv;
        String $this$rasaClassifiedFormat_u24lambda_u240 = $this$rasaClassifiedFormat.getText();
        boolean bl = false;
        String result = null;
        result = $this$rasaClassifiedFormat_u24lambda_u240;
        Iterable $this$sortedByDescending$iv = $this$rasaClassifiedFormat.getEntities();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SampleEntity it = (SampleEntity)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (SampleEntity)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SampleEntity entity = (SampleEntity)element$iv;
            boolean bl2 = false;
            IntRange range = entity.toClosedRange();
            String string = result;
            CharSequence charSequence = "[" + StringsKt.substring((String)$this$rasaClassifiedFormat_u24lambda_u240, (IntRange)range) + "]{\"entity\":\"" + RasaConfigurationKt.escapeRasaName(entity.getDefinition().getEntityType().getName()) + "\",\"role\":\"" + entity.getDefinition().getRole() + "\"}";
            result = ((Object)StringsKt.replaceRange((CharSequence)string, (IntRange)range, (CharSequence)charSequence)).toString();
        }
        return result;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence toModelDomainMarkdown$lambda$0(Intent i) {
        String string;
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        String string2 = RasaConfigurationKt.escapeRasaName(i.getName());
        if (i.getEntities().isEmpty()) {
            string = " []";
        } else {
            void $this$distinctBy$iv;
            Iterable iterable = i.getEntities();
            String string3 = string2;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Entity it = (Entity)e$iv;
                boolean bl = false;
                String key$iv = it.getEntityType().getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            string2 = string3;
            string = CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, RasaMarkdown::toModelDomainMarkdown$lambda$0$1, (int)28, null);
        }
        return "  - " + string2 + ":\n      use_entities:" + string;
    }

    private static final CharSequence toModelDomainMarkdown$lambda$0$1(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "        - " + RasaConfigurationKt.escapeRasaName(it.getEntityType().getName());
    }

    private static final CharSequence toModelDomainMarkdown$lambda$3(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  - " + RasaConfigurationKt.escapeRasaName(it.getEntityType().getName());
    }

    private static final Object toModelDomainMarkdown$lambda$4$0(String $it) {
        return $it;
    }

    private static final CharSequence toModelNluMarkdown$lambda$1$0(SampleExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- " + INSTANCE.rasaClassifiedFormat(it);
    }

    private static final Object toModelNluMarkdown$lambda$2$0(String $it) {
        return $it;
    }
}

