/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.rasa;

import ai.tock.shared.PropertiesKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0011"}, d2={"Lai/tock/nlp/rasa/RasaConfiguration;", "", "rasaUrl", "", "modelBasePath", "configuration", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRasaUrl", "()Ljava/lang/String;", "getModelBasePath", "getConfiguration", "getMarkdownConfiguration", "locale", "Ljava/util/Locale;", "getModelFilePath", "fileName", "tock-nlp-model-rasa"})
public final class RasaConfiguration {
    @NotNull
    private final String rasaUrl;
    @NotNull
    private final String modelBasePath;
    @NotNull
    private final String configuration;

    public RasaConfiguration(@NotNull String rasaUrl, @NotNull String modelBasePath, @NotNull String configuration) {
        Intrinsics.checkNotNullParameter((Object)rasaUrl, (String)"rasaUrl");
        Intrinsics.checkNotNullParameter((Object)modelBasePath, (String)"modelBasePath");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.rasaUrl = rasaUrl;
        this.modelBasePath = modelBasePath;
        this.configuration = configuration;
    }

    public /* synthetic */ RasaConfiguration(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "http://localhost:5005";
        }
        if ((n & 2) != 0) {
            string2 = PropertiesKt.property((String)"rasa_model_path", (String)"models/");
        }
        if ((n & 4) != 0) {
            string3 = "language: en\npipeline: supervised_embeddings\npolicies:\n  - name: MemoizationPolicy\n  - name: KerasPolicy";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getRasaUrl() {
        return this.rasaUrl;
    }

    @NotNull
    public final String getModelBasePath() {
        return this.modelBasePath;
    }

    @NotNull
    public final String getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final String getMarkdownConfiguration(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return Intrinsics.areEqual((Object)locale.getLanguage(), (Object)Locale.ENGLISH.getLanguage()) ? "\npipeline:\n  - name: ConveRTTokenizer\n  - name: ConveRTFeaturizer\n  - name: RegexFeaturizer\n  - name: LexicalSyntacticFeaturizer\n  - name: CountVectorsFeaturizer\n  - name: CountVectorsFeaturizer\n    analyzer: \"char_wb\"\n    min_ngram: 1\n    max_ngram: 4\n  - name: DIETClassifier\n    epochs: 100\n  - name: EntitySynonymMapper\n  - name: ResponseSelector\n    epochs: 100" : "language: \"" + locale.getLanguage() + "\"  # your two-letter language code\n\npipeline:\n  - name: WhitespaceTokenizer\n  - name: RegexFeaturizer\n  - name: LexicalSyntacticFeaturizer\n  - name: CountVectorsFeaturizer\n  - name: CountVectorsFeaturizer\n    analyzer: \"char_wb\"\n    min_ngram: 1\n    max_ngram: 4\n  - name: DIETClassifier\n    epochs: 100\n  - name: EntitySynonymMapper\n  - name: ResponseSelector\n    epochs: 100";
    }

    @NotNull
    public final String getModelFilePath(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.modelBasePath + fileName;
    }

    public RasaConfiguration() {
        this(null, null, null, 7, null);
    }
}

