/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.rasa;

import ai.tock.nlp.rasa.RasaConfiguration;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Streaming;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\b\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/tock/nlp/rasa/RasaClient;", "", "conf", "Lai/tock/nlp/rasa/RasaConfiguration;", "<init>", "(Lai/tock/nlp/rasa/RasaConfiguration;)V", "api", "Lai/tock/nlp/rasa/RasaClient$RasaApi;", "train", "", "request", "Lai/tock/nlp/rasa/RasaClient$TrainModelRequest;", "setModel", "", "Lai/tock/nlp/rasa/RasaClient$PutModelRequest;", "parse", "Lai/tock/nlp/rasa/RasaClient$ParsedResponse;", "Lai/tock/nlp/rasa/RasaClient$ParseRequest;", "healthcheck", "", "TrainModelRequest", "PutModelRequest", "ParseRequest", "ParsedResponse", "ParsedIntent", "ParsedEntity", "RasaApi", "Companion", "tock-nlp-model-rasa"})
@SourceDebugExtension(value={"SMAP\nRasaClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasaClient.kt\nai/tock/nlp/rasa/RasaClient\n+ 2 KotlinExtensions.kt\nretrofit2/KotlinExtensions\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n29#2:134\n1#3:135\n*S KotlinDebug\n*F\n+ 1 RasaClient.kt\nai/tock/nlp/rasa/RasaClient\n*L\n97#1:134\n*E\n"})
public final class RasaClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RasaApi api;
    private static final long timeoutInSeconds = PropertiesKt.longProperty((String)"tock_bot_rest_timeout_in_ms", (long)100000000L);
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(RasaClient::logger$lambda$0);

    public RasaClient(@NotNull RasaConfiguration conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)timeoutInSeconds, null, null, null, (boolean)false, (boolean)false, null, (int)126, null), null, (int)1, null).baseUrl(conf.getRasaUrl()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(RasaApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.api = (RasaApi)object;
    }

    @NotNull
    public final String train(@NotNull TrainModelRequest request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Response $this$train_u24lambda_u240 = this.api.train(request).execute();
        boolean bl = false;
        if ($this$train_u24lambda_u240.isSuccessful()) {
            string = $this$train_u24lambda_u240.headers().get("filename");
            if (string == null) {
                throw new IllegalStateException("no file name".toString());
            }
        } else {
            Object object = $this$train_u24lambda_u240.errorBody();
            if (object == null || (object = object.string()) == null) {
                object = "unknown error";
            }
            Object object2 = object;
            throw new IllegalStateException(object2.toString());
        }
        return string;
    }

    public final void setModel(@NotNull PutModelRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Response $this$setModel_u24lambda_u240 = this.api.setModel(request).execute();
        boolean bl = false;
        if (!$this$setModel_u24lambda_u240.isSuccessful()) {
            Object object = $this$setModel_u24lambda_u240.errorBody();
            if (object == null || (object = object.string()) == null) {
                object = "unknown error";
            }
            Object object2 = object;
            throw new IllegalStateException(object2.toString());
        }
    }

    @NotNull
    public final ParsedResponse parse(@NotNull ParseRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Response $this$parse_u24lambda_u240 = this.api.parse(request).execute();
        boolean bl = false;
        ParsedResponse parsedResponse = (ParsedResponse)$this$parse_u24lambda_u240.body();
        if (parsedResponse == null) {
            Object object = $this$parse_u24lambda_u240.errorBody();
            if (object == null || (object = object.string()) == null) {
                object = "unknown error";
            }
            Object object2 = object;
            throw new IllegalStateException(object2.toString());
        }
        return parsedResponse;
    }

    public final boolean healthcheck() {
        boolean bl;
        try {
            bl = this.api.healthcheck().execute().isSuccessful();
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/tock/nlp/rasa/RasaClient$Companion;", "", "<init>", "()V", "timeoutInSeconds", "", "logger", "Lmu/KLogger;", "tock-nlp-model-rasa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lai/tock/nlp/rasa/RasaClient$ParseRequest;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-model-rasa"})
    public static final class ParseRequest {
        @NotNull
        private final String text;

        public ParseRequest(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final ParseRequest copy(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new ParseRequest(text);
        }

        public static /* synthetic */ ParseRequest copy$default(ParseRequest parseRequest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = parseRequest.text;
            }
            return parseRequest.copy(string);
        }

        @NotNull
        public String toString() {
            return "ParseRequest(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseRequest)) {
                return false;
            }
            ParseRequest parseRequest = (ParseRequest)other;
            return Intrinsics.areEqual((Object)this.text, (Object)parseRequest.text);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003JS\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006%"}, d2={"Lai/tock/nlp/rasa/RasaClient$ParsedEntity;", "", "start", "", "end", "value", "", "entity", "confidence", "", "role", "extractor", "<init>", "(IILjava/lang/String;Ljava/lang/String;DLjava/lang/String;Ljava/lang/String;)V", "getStart", "()I", "getEnd", "getValue", "()Ljava/lang/String;", "getEntity", "getConfidence", "()D", "getRole", "getExtractor", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "tock-nlp-model-rasa"})
    public static final class ParsedEntity {
        private final int start;
        private final int end;
        @NotNull
        private final String value;
        @NotNull
        private final String entity;
        private final double confidence;
        @Nullable
        private final String role;
        @Nullable
        private final String extractor;

        public ParsedEntity(int start, int end, @NotNull String value, @NotNull String entity, double confidence, @Nullable String role, @Nullable String extractor) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            this.start = start;
            this.end = end;
            this.value = value;
            this.entity = entity;
            this.confidence = confidence;
            this.role = role;
            this.extractor = extractor;
        }

        public /* synthetic */ ParsedEntity(int n, int n2, String string, String string2, double d, String string3, String string4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x20) != 0) {
                string3 = null;
            }
            if ((n3 & 0x40) != 0) {
                string4 = null;
            }
            this(n, n2, string, string2, d, string3, string4);
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getEntity() {
            return this.entity;
        }

        public final double getConfidence() {
            return this.confidence;
        }

        @Nullable
        public final String getRole() {
            return this.role;
        }

        @Nullable
        public final String getExtractor() {
            return this.extractor;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final String component3() {
            return this.value;
        }

        @NotNull
        public final String component4() {
            return this.entity;
        }

        public final double component5() {
            return this.confidence;
        }

        @Nullable
        public final String component6() {
            return this.role;
        }

        @Nullable
        public final String component7() {
            return this.extractor;
        }

        @NotNull
        public final ParsedEntity copy(int start, int end, @NotNull String value, @NotNull String entity, double confidence, @Nullable String role, @Nullable String extractor) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new ParsedEntity(start, end, value, entity, confidence, role, extractor);
        }

        public static /* synthetic */ ParsedEntity copy$default(ParsedEntity parsedEntity, int n, int n2, String string, String string2, double d, String string3, String string4, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = parsedEntity.start;
            }
            if ((n3 & 2) != 0) {
                n2 = parsedEntity.end;
            }
            if ((n3 & 4) != 0) {
                string = parsedEntity.value;
            }
            if ((n3 & 8) != 0) {
                string2 = parsedEntity.entity;
            }
            if ((n3 & 0x10) != 0) {
                d = parsedEntity.confidence;
            }
            if ((n3 & 0x20) != 0) {
                string3 = parsedEntity.role;
            }
            if ((n3 & 0x40) != 0) {
                string4 = parsedEntity.extractor;
            }
            return parsedEntity.copy(n, n2, string, string2, d, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ParsedEntity(start=" + this.start + ", end=" + this.end + ", value=" + this.value + ", entity=" + this.entity + ", confidence=" + this.confidence + ", role=" + this.role + ", extractor=" + this.extractor + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.value.hashCode();
            result = result * 31 + this.entity.hashCode();
            result = result * 31 + Double.hashCode(this.confidence);
            result = result * 31 + (this.role == null ? 0 : this.role.hashCode());
            result = result * 31 + (this.extractor == null ? 0 : this.extractor.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedEntity)) {
                return false;
            }
            ParsedEntity parsedEntity = (ParsedEntity)other;
            if (this.start != parsedEntity.start) {
                return false;
            }
            if (this.end != parsedEntity.end) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)parsedEntity.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.entity, (Object)parsedEntity.entity)) {
                return false;
            }
            if (Double.compare(this.confidence, parsedEntity.confidence) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.role, (Object)parsedEntity.role)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extractor, (Object)parsedEntity.extractor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lai/tock/nlp/rasa/RasaClient$ParsedIntent;", "", "name", "", "confidence", "", "<init>", "(Ljava/lang/String;D)V", "getName", "()Ljava/lang/String;", "getConfidence", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-model-rasa"})
    public static final class ParsedIntent {
        @NotNull
        private final String name;
        private final double confidence;

        public ParsedIntent(@NotNull String name, double confidence) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.confidence = confidence;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final double getConfidence() {
            return this.confidence;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final double component2() {
            return this.confidence;
        }

        @NotNull
        public final ParsedIntent copy(@NotNull String name, double confidence) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ParsedIntent(name, confidence);
        }

        public static /* synthetic */ ParsedIntent copy$default(ParsedIntent parsedIntent, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = parsedIntent.name;
            }
            if ((n & 2) != 0) {
                d = parsedIntent.confidence;
            }
            return parsedIntent.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "ParsedIntent(name=" + this.name + ", confidence=" + this.confidence + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Double.hashCode(this.confidence);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedIntent)) {
                return false;
            }
            ParsedIntent parsedIntent = (ParsedIntent)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)parsedIntent.name)) {
                return false;
            }
            return Double.compare(this.confidence, parsedIntent.confidence) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J5\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/rasa/RasaClient$ParsedResponse;", "", "entities", "", "Lai/tock/nlp/rasa/RasaClient$ParsedEntity;", "intent", "Lai/tock/nlp/rasa/RasaClient$ParsedIntent;", "intent_ranking", "<init>", "(Ljava/util/List;Lai/tock/nlp/rasa/RasaClient$ParsedIntent;Ljava/util/List;)V", "getEntities", "()Ljava/util/List;", "getIntent", "()Lai/tock/nlp/rasa/RasaClient$ParsedIntent;", "getIntent_ranking", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-model-rasa"})
    public static final class ParsedResponse {
        @NotNull
        private final List<ParsedEntity> entities;
        @Nullable
        private final ParsedIntent intent;
        @NotNull
        private final List<ParsedIntent> intent_ranking;

        public ParsedResponse(@NotNull List<ParsedEntity> entities, @Nullable ParsedIntent intent, @NotNull List<ParsedIntent> intent_ranking) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            Intrinsics.checkNotNullParameter(intent_ranking, (String)"intent_ranking");
            this.entities = entities;
            this.intent = intent;
            this.intent_ranking = intent_ranking;
        }

        public /* synthetic */ ParsedResponse(List list, ParsedIntent parsedIntent, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                parsedIntent = null;
            }
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, parsedIntent, list2);
        }

        @NotNull
        public final List<ParsedEntity> getEntities() {
            return this.entities;
        }

        @Nullable
        public final ParsedIntent getIntent() {
            return this.intent;
        }

        @NotNull
        public final List<ParsedIntent> getIntent_ranking() {
            return this.intent_ranking;
        }

        @NotNull
        public final List<ParsedEntity> component1() {
            return this.entities;
        }

        @Nullable
        public final ParsedIntent component2() {
            return this.intent;
        }

        @NotNull
        public final List<ParsedIntent> component3() {
            return this.intent_ranking;
        }

        @NotNull
        public final ParsedResponse copy(@NotNull List<ParsedEntity> entities, @Nullable ParsedIntent intent, @NotNull List<ParsedIntent> intent_ranking) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            Intrinsics.checkNotNullParameter(intent_ranking, (String)"intent_ranking");
            return new ParsedResponse(entities, intent, intent_ranking);
        }

        public static /* synthetic */ ParsedResponse copy$default(ParsedResponse parsedResponse, List list, ParsedIntent parsedIntent, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = parsedResponse.entities;
            }
            if ((n & 2) != 0) {
                parsedIntent = parsedResponse.intent;
            }
            if ((n & 4) != 0) {
                list2 = parsedResponse.intent_ranking;
            }
            return parsedResponse.copy(list, parsedIntent, list2);
        }

        @NotNull
        public String toString() {
            return "ParsedResponse(entities=" + this.entities + ", intent=" + this.intent + ", intent_ranking=" + this.intent_ranking + ")";
        }

        public int hashCode() {
            int result = ((Object)this.entities).hashCode();
            result = result * 31 + (this.intent == null ? 0 : this.intent.hashCode());
            result = result * 31 + ((Object)this.intent_ranking).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedResponse)) {
                return false;
            }
            ParsedResponse parsedResponse = (ParsedResponse)other;
            if (!Intrinsics.areEqual(this.entities, parsedResponse.entities)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.intent, (Object)parsedResponse.intent)) {
                return false;
            }
            return Intrinsics.areEqual(this.intent_ranking, parsedResponse.intent_ranking);
        }

        public ParsedResponse() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lai/tock/nlp/rasa/RasaClient$PutModelRequest;", "", "model_file", "", "remote_storage", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getModel_file", "()Ljava/lang/String;", "getRemote_storage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-model-rasa"})
    public static final class PutModelRequest {
        @NotNull
        private final String model_file;
        @Nullable
        private final String remote_storage;

        public PutModelRequest(@NotNull String model_file, @Nullable String remote_storage) {
            Intrinsics.checkNotNullParameter((Object)model_file, (String)"model_file");
            this.model_file = model_file;
            this.remote_storage = remote_storage;
        }

        public /* synthetic */ PutModelRequest(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @NotNull
        public final String getModel_file() {
            return this.model_file;
        }

        @Nullable
        public final String getRemote_storage() {
            return this.remote_storage;
        }

        @NotNull
        public final String component1() {
            return this.model_file;
        }

        @Nullable
        public final String component2() {
            return this.remote_storage;
        }

        @NotNull
        public final PutModelRequest copy(@NotNull String model_file, @Nullable String remote_storage) {
            Intrinsics.checkNotNullParameter((Object)model_file, (String)"model_file");
            return new PutModelRequest(model_file, remote_storage);
        }

        public static /* synthetic */ PutModelRequest copy$default(PutModelRequest putModelRequest, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = putModelRequest.model_file;
            }
            if ((n & 2) != 0) {
                string2 = putModelRequest.remote_storage;
            }
            return putModelRequest.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "PutModelRequest(model_file=" + this.model_file + ", remote_storage=" + this.remote_storage + ")";
        }

        public int hashCode() {
            int result = this.model_file.hashCode();
            result = result * 31 + (this.remote_storage == null ? 0 : this.remote_storage.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PutModelRequest)) {
                return false;
            }
            PutModelRequest putModelRequest = (PutModelRequest)other;
            if (!Intrinsics.areEqual((Object)this.model_file, (Object)putModelRequest.model_file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.remote_storage, (Object)putModelRequest.remote_storage);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\tH'J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u000bH'J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lai/tock/nlp/rasa/RasaClient$RasaApi;", "", "train", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "request", "Lai/tock/nlp/rasa/RasaClient$TrainModelRequest;", "parse", "Lai/tock/nlp/rasa/RasaClient$ParsedResponse;", "Lai/tock/nlp/rasa/RasaClient$ParseRequest;", "setModel", "Lai/tock/nlp/rasa/RasaClient$PutModelRequest;", "healthcheck", "tock-nlp-model-rasa"})
    private static interface RasaApi {
        @Streaming
        @Headers(value={"Content-Type:application/json"})
        @POST(value="model/train")
        @NotNull
        public Call<ResponseBody> train(@Body @NotNull TrainModelRequest var1);

        @Headers(value={"Content-Type:application/json"})
        @POST(value="model/parse")
        @NotNull
        public Call<ParsedResponse> parse(@Body @NotNull ParseRequest var1);

        @Headers(value={"Content-Type:application/json"})
        @PUT(value="model")
        @NotNull
        public Call<ResponseBody> setModel(@Body @NotNull PutModelRequest var1);

        @GET(value="")
        @NotNull
        public Call<ResponseBody> healthcheck();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/rasa/RasaClient$TrainModelRequest;", "", "domain", "", "config", "nlu", "save_to_default_model_directory", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getDomain", "()Ljava/lang/String;", "getConfig", "getNlu", "getSave_to_default_model_directory", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "tock-nlp-model-rasa"})
    public static final class TrainModelRequest {
        @NotNull
        private final String domain;
        @NotNull
        private final String config;
        @NotNull
        private final String nlu;
        private final boolean save_to_default_model_directory;

        public TrainModelRequest(@NotNull String domain, @NotNull String config, @NotNull String nlu, boolean save_to_default_model_directory) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)nlu, (String)"nlu");
            this.domain = domain;
            this.config = config;
            this.nlu = nlu;
            this.save_to_default_model_directory = save_to_default_model_directory;
        }

        public /* synthetic */ TrainModelRequest(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = true;
            }
            this(string, string2, string3, bl);
        }

        @NotNull
        public final String getDomain() {
            return this.domain;
        }

        @NotNull
        public final String getConfig() {
            return this.config;
        }

        @NotNull
        public final String getNlu() {
            return this.nlu;
        }

        public final boolean getSave_to_default_model_directory() {
            return this.save_to_default_model_directory;
        }

        @NotNull
        public final String component1() {
            return this.domain;
        }

        @NotNull
        public final String component2() {
            return this.config;
        }

        @NotNull
        public final String component3() {
            return this.nlu;
        }

        public final boolean component4() {
            return this.save_to_default_model_directory;
        }

        @NotNull
        public final TrainModelRequest copy(@NotNull String domain, @NotNull String config, @NotNull String nlu, boolean save_to_default_model_directory) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)nlu, (String)"nlu");
            return new TrainModelRequest(domain, config, nlu, save_to_default_model_directory);
        }

        public static /* synthetic */ TrainModelRequest copy$default(TrainModelRequest trainModelRequest, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = trainModelRequest.domain;
            }
            if ((n & 2) != 0) {
                string2 = trainModelRequest.config;
            }
            if ((n & 4) != 0) {
                string3 = trainModelRequest.nlu;
            }
            if ((n & 8) != 0) {
                bl = trainModelRequest.save_to_default_model_directory;
            }
            return trainModelRequest.copy(string, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "TrainModelRequest(domain=" + this.domain + ", config=" + this.config + ", nlu=" + this.nlu + ", save_to_default_model_directory=" + this.save_to_default_model_directory + ")";
        }

        public int hashCode() {
            int result = this.domain.hashCode();
            result = result * 31 + this.config.hashCode();
            result = result * 31 + this.nlu.hashCode();
            result = result * 31 + Boolean.hashCode(this.save_to_default_model_directory);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrainModelRequest)) {
                return false;
            }
            TrainModelRequest trainModelRequest = (TrainModelRequest)other;
            if (!Intrinsics.areEqual((Object)this.domain, (Object)trainModelRequest.domain)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.config, (Object)trainModelRequest.config)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nlu, (Object)trainModelRequest.nlu)) {
                return false;
            }
            return this.save_to_default_model_directory == trainModelRequest.save_to_default_model_directory;
        }
    }
}

