/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.opennlp;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityValue;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.NlpEntityClassifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0014J1\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0016J?\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/tock/nlp/opennlp/OpenNlpEntityClassifier;", "Lai/tock/nlp/model/service/engine/NlpEntityClassifier;", "model", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "<init>", "(Lai/tock/nlp/model/service/engine/EntityModelHolder;)V", "logger", "Lmu/KLogger;", "classifyEntities", "", "Lai/tock/nlp/core/EntityRecognition;", "context", "Lai/tock/nlp/model/EntityCallContext;", "text", "", "tokens", "", "(Lai/tock/nlp/model/EntityCallContext;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "classify", "Lai/tock/nlp/model/EntityCallContextForSubEntities;", "(Lai/tock/nlp/model/EntityCallContextForSubEntities;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Lai/tock/nlp/model/EntityCallContextForIntent;", "(Lai/tock/nlp/model/EntityCallContextForIntent;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "entityFinder", "Lkotlin/Function1;", "Lai/tock/nlp/core/Entity;", "(Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "tock-nlp-model-opennlp"})
@SourceDebugExtension(value={"SMAP\nOpenNlpEntityClassifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenNlpEntityClassifier.kt\nai/tock/nlp/opennlp/OpenNlpEntityClassifier\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n11741#2,11:111\n13870#2,2:122\n13872#2:126\n11752#2:127\n1#3:124\n1#3:125\n*S KotlinDebug\n*F\n+ 1 OpenNlpEntityClassifier.kt\nai/tock/nlp/opennlp/OpenNlpEntityClassifier\n*L\n62#1:111,11\n62#1:122,2\n62#1:126\n62#1:127\n62#1:125\n*E\n"})
public final class OpenNlpEntityClassifier
extends NlpEntityClassifier {
    @NotNull
    private final KLogger logger;

    public OpenNlpEntityClassifier(@NotNull EntityModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
        this.logger = KotlinLogging.INSTANCE.logger(OpenNlpEntityClassifier::logger$lambda$0);
    }

    @NotNull
    public List<EntityRecognition> classifyEntities(@NotNull EntityCallContext context, @NotNull String text, @NotNull String[] tokens) {
        List<EntityRecognition> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classify((EntityCallContextForIntent)context, text, tokens);
        } else {
            if (entityCallContext instanceof EntityCallContextForEntity) {
                throw new IllegalStateException("EntityCallContextForEntity is not supported".toString());
            }
            if (entityCallContext instanceof EntityCallContextForSubEntities) {
                list = this.classify((EntityCallContextForSubEntities)context, text, tokens);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<EntityRecognition> classify(EntityCallContextForSubEntities context, String text, String[] tokens) {
        return this.classify(text, tokens, (Function1<? super String, Entity>)((Function1)arg_0 -> OpenNlpEntityClassifier.classify$lambda$0(context, arg_0)));
    }

    private final List<EntityRecognition> classify(EntityCallContextForIntent context, String text, String[] tokens) {
        return this.classify(text, tokens, (Function1<? super String, Entity>)((Function1)arg_0 -> OpenNlpEntityClassifier.classify$lambda$1(context, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityRecognition> classify(String text, String[] tokens, Function1<? super String, Entity> entityFinder) {
        void $this$mapIndexedNotNullTo$iv$iv;
        EntityModelHolder $this$classify_u24lambda_u242 = this.getModel();
        boolean bl = false;
        Object object = $this$classify_u24lambda_u242.getNativeModel();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type opennlp.tools.namefind.NameFinderME");
        NameFinderME finder = (NameFinderME)object;
        Span[] spans = finder.find(tokens);
        double entityProbability = 0.0;
        int nbEntitySpans = 0;
        Intrinsics.checkNotNull((Object)spans);
        Span[] $this$mapIndexedNotNull$iv = spans;
        boolean $i$f$mapIndexedNotNull = false;
        Span[] spanArray = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            EntityRecognition entityRecognition;
            void span;
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            void var20_21 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl2 = false;
            void var23_24 = element$iv$iv;
            int index = index$iv$iv;
            boolean bl3 = false;
            entityProbability += span.getProb();
            ++nbEntitySpans;
            int nextIndex = index + 1;
            if (nextIndex < spans.length && Intrinsics.areEqual((Object)spans[nextIndex].getType(), (Object)span.getType()) && span.getEnd() == spans[nextIndex].getStart()) {
                entityRecognition = null;
            } else {
                int n2;
                String t = text;
                int start = 0;
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)(nbEntitySpans - 1));
                int n3 = span.getStart();
                int n4 = 0;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int n5;
                    int n6 = n5 = ((IntIterator)iterator).nextInt();
                    n2 = n4;
                    boolean bl4 = false;
                    int n7 = spans[index - it - 1].length();
                    n4 = n2 + n7;
                }
                n2 = n4;
                int tokenStart = n3 - n2;
                for (int i = 0; i < tokenStart; ++i) {
                    int nextTokenIndex = tokens[i].length() + StringsKt.indexOf$default((CharSequence)t, (String)tokens[i], (int)0, (boolean)false, (int)6, null);
                    start += nextTokenIndex;
                    Intrinsics.checkNotNullExpressionValue((Object)t.substring(nextTokenIndex), (String)"substring(...)");
                }
                int end = start;
                start += StringsKt.indexOf$default((CharSequence)t, (String)tokens[tokenStart], (int)0, (boolean)false, (int)6, null);
                int n8 = span.getEnd();
                for (int i = tokenStart; i < n8; ++i) {
                    int nextTokenIndex = tokens[i].length() + StringsKt.indexOf$default((CharSequence)t, (String)tokens[i], (int)0, (boolean)false, (int)6, null);
                    end += nextTokenIndex;
                    Intrinsics.checkNotNullExpressionValue((Object)t.substring(nextTokenIndex), (String)"substring(...)");
                }
                if (end > text.length()) {
                    throw new IllegalStateException("Parsing error".toString());
                }
                double entityProba = entityProbability / (double)nbEntitySpans;
                entityProbability = 0.0;
                nbEntitySpans = 0;
                String string = span.getType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
                Entity entity = (Entity)entityFinder.invoke((Object)string);
                if (entity == null) {
                    this.logger.warn(() -> OpenNlpEntityClassifier.classify$lambda$2$0$1((Span)span));
                    entityRecognition = null;
                } else {
                    entityRecognition = new EntityRecognition(new EntityValue(start, end, entity, null, null, false, 48, null), entityProba);
                }
            }
            if (entityRecognition == null) continue;
            EntityRecognition it$iv$iv = entityRecognition;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Entity classify$lambda$0(EntityCallContextForSubEntities $context, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $context.getEntityType().findSubEntity(it);
    }

    private static final Entity classify$lambda$1(EntityCallContextForIntent $context, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $context.getIntent().getEntity(it);
    }

    private static final Object classify$lambda$2$0$1(Span $span) {
        return "unknown entity role " + $span.getType();
    }
}

