/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.integration;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.entity.Value;
import ai.tock.nlp.entity.date.DateEntityGrain;
import ai.tock.nlp.entity.date.DateEntityValue;
import ai.tock.nlp.front.client.FrontClient;
import ai.tock.nlp.front.shared.parser.ParseQuery;
import ai.tock.nlp.front.shared.parser.ParseResult;
import ai.tock.nlp.front.shared.parser.ParsedEntityValue;
import ai.tock.nlp.front.shared.parser.QueryContext;
import ai.tock.nlp.integration.IntegrationConfiguration;
import ai.tock.shared.DatesKt;
import ai.tock.shared.NamespacesKt;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/tock/nlp/integration/IntegrationTest;", "", "()V", "testOpenNlpSimpleRequest", "", "Companion", "tock-nlp-integration-tests"})
public final class IntegrationTest {
    public static final Companion Companion = new Companion(null);

    @Test
    public final void testOpenNlpSimpleRequest() {
        List list = CollectionsKt.listOf((Object)"I want to go to Paris tomorrow");
        String string = NamespacesKt.getDefaultNamespace();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
        ParseResult result = FrontClient.INSTANCE.parse(new ParseQuery(list, string, "test", new QueryContext(locale, "clientTest", null, null, null, null, false, false, false, false, 1020, null), null, null, 48, null));
        boolean bl = false;
        System.out.println(result);
        AssertionsKt.assertEquals$default((Object)"travel", (Object)result.getIntent(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)result.getEntities().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)new ParsedEntityValue(16, 21, new Entity(new EntityType(NamespacesKt.getDefaultNamespace() + ":locality", null, false, false, 14, null), "locality"), null, false, null, 0.30666386016073854, false, 176, null), (Object)result.firstValue("locality"), null, (int)4, null);
        Entity entity = new Entity(new EntityType("duckling:datetime", null, false, false, 14, null), "datetime");
        ZonedDateTime zonedDateTime = ZonedDateTime.now().withZoneSameInstant(DatesKt.getDefaultZoneId()).plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0).withFixedOffsetZone();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now().with\u2026(0).withFixedOffsetZone()");
        AssertionsKt.assertEquals$default((Object)new ParsedEntityValue(22, 30, entity, (Value)new DateEntityValue(zonedDateTime, DateEntityGrain.day), true, null, 0.6447195532270447, true, 32, null), (Object)result.firstValue("datetime"), null, (int)4, null);
    }

    @BeforeAll
    @JvmStatic
    public static final void beforeClass() {
        Companion.beforeClass();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lai/tock/nlp/integration/IntegrationTest$Companion;", "", "()V", "beforeClass", "", "tock-nlp-integration-tests"})
    public static final class Companion {
        @BeforeAll
        @JvmStatic
        public final void beforeClass() {
            IntegrationConfiguration.INSTANCE.init(NlpEngineType.Companion.getOpennlp());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

