/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Observable;
import rx.Subscriber;
import rx.observers.SerializedObserver;
import rx.subjects.Subject;

public class SerializedSubject<T, R>
extends Subject<T, R> {
    private final SerializedObserver<T> observer;
    private final Subject<T, R> actual;

    public SerializedSubject(final Subject<T, R> actual) {
        super(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> child) {
                actual.unsafeSubscribe(child);
            }
        });
        this.actual = actual;
        this.observer = new SerializedObserver(actual);
    }

    @Override
    public void onCompleted() {
        this.observer.onCompleted();
    }

    @Override
    public void onError(Throwable e2) {
        this.observer.onError(e2);
    }

    @Override
    public void onNext(T t3) {
        this.observer.onNext(t3);
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }
}

