/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import rx.plugins.RxJavaCompletableExecutionHook;
import rx.plugins.RxJavaErrorHandler;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaObservableExecutionHookDefault;
import rx.plugins.RxJavaSchedulersHook;
import rx.plugins.RxJavaSingleExecutionHook;
import rx.plugins.RxJavaSingleExecutionHookDefault;

public class RxJavaPlugins {
    private static final RxJavaPlugins INSTANCE = new RxJavaPlugins();
    private final AtomicReference<RxJavaErrorHandler> errorHandler = new AtomicReference();
    private final AtomicReference<RxJavaObservableExecutionHook> observableExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaSingleExecutionHook> singleExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaCompletableExecutionHook> completableExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaSchedulersHook> schedulersHook = new AtomicReference();
    static final RxJavaErrorHandler DEFAULT_ERROR_HANDLER = new RxJavaErrorHandler(){};

    @Deprecated
    public static RxJavaPlugins getInstance() {
        return INSTANCE;
    }

    RxJavaPlugins() {
    }

    public void reset() {
        RxJavaPlugins.INSTANCE.errorHandler.set(null);
        RxJavaPlugins.INSTANCE.observableExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.singleExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.completableExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.schedulersHook.set(null);
    }

    public RxJavaErrorHandler getErrorHandler() {
        if (this.errorHandler.get() == null) {
            Object impl2 = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaErrorHandler.class, RxJavaPlugins.getSystemPropertiesSafe());
            if (impl2 == null) {
                this.errorHandler.compareAndSet(null, DEFAULT_ERROR_HANDLER);
            } else {
                this.errorHandler.compareAndSet(null, (RxJavaErrorHandler)impl2);
            }
        }
        return this.errorHandler.get();
    }

    public void registerErrorHandler(RxJavaErrorHandler impl2) {
        if (!this.errorHandler.compareAndSet(null, impl2)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.errorHandler.get());
        }
    }

    public RxJavaObservableExecutionHook getObservableExecutionHook() {
        if (this.observableExecutionHook.get() == null) {
            Object impl2 = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaObservableExecutionHook.class, RxJavaPlugins.getSystemPropertiesSafe());
            if (impl2 == null) {
                this.observableExecutionHook.compareAndSet(null, RxJavaObservableExecutionHookDefault.getInstance());
            } else {
                this.observableExecutionHook.compareAndSet(null, (RxJavaObservableExecutionHook)impl2);
            }
        }
        return this.observableExecutionHook.get();
    }

    public void registerObservableExecutionHook(RxJavaObservableExecutionHook impl2) {
        if (!this.observableExecutionHook.compareAndSet(null, impl2)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.observableExecutionHook.get());
        }
    }

    public RxJavaSingleExecutionHook getSingleExecutionHook() {
        if (this.singleExecutionHook.get() == null) {
            Object impl2 = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaSingleExecutionHook.class, RxJavaPlugins.getSystemPropertiesSafe());
            if (impl2 == null) {
                this.singleExecutionHook.compareAndSet(null, RxJavaSingleExecutionHookDefault.getInstance());
            } else {
                this.singleExecutionHook.compareAndSet(null, (RxJavaSingleExecutionHook)impl2);
            }
        }
        return this.singleExecutionHook.get();
    }

    public void registerSingleExecutionHook(RxJavaSingleExecutionHook impl2) {
        if (!this.singleExecutionHook.compareAndSet(null, impl2)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.singleExecutionHook.get());
        }
    }

    public RxJavaCompletableExecutionHook getCompletableExecutionHook() {
        if (this.completableExecutionHook.get() == null) {
            Object impl2 = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaCompletableExecutionHook.class, RxJavaPlugins.getSystemPropertiesSafe());
            if (impl2 == null) {
                this.completableExecutionHook.compareAndSet(null, new RxJavaCompletableExecutionHook(){});
            } else {
                this.completableExecutionHook.compareAndSet(null, (RxJavaCompletableExecutionHook)impl2);
            }
        }
        return this.completableExecutionHook.get();
    }

    public void registerCompletableExecutionHook(RxJavaCompletableExecutionHook impl2) {
        if (!this.completableExecutionHook.compareAndSet(null, impl2)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.singleExecutionHook.get());
        }
    }

    static Properties getSystemPropertiesSafe() {
        try {
            return System.getProperties();
        }
        catch (SecurityException ex) {
            return new Properties();
        }
    }

    static Object getPluginImplementationViaProperty(Class<?> pluginClass, Properties propsIn) {
        Properties props = (Properties)propsIn.clone();
        String classSimpleName = pluginClass.getSimpleName();
        String pluginPrefix = "rxjava.plugin.";
        String defaultKey = pluginPrefix + classSimpleName + ".implementation";
        String implementingClass = props.getProperty(defaultKey);
        if (implementingClass == null) {
            String classSuffix = ".class";
            String implSuffix = ".impl";
            try {
                for (Map.Entry<Object, Object> e2 : props.entrySet()) {
                    String value;
                    String key2 = e2.getKey().toString();
                    if (!key2.startsWith(pluginPrefix) || !key2.endsWith(classSuffix) || !classSimpleName.equals(value = e2.getValue().toString())) continue;
                    String index2 = key2.substring(0, key2.length() - classSuffix.length()).substring(pluginPrefix.length());
                    String implKey = pluginPrefix + index2 + implSuffix;
                    implementingClass = props.getProperty(implKey);
                    if (implementingClass != null) break;
                    throw new IllegalStateException("Implementing class declaration for " + classSimpleName + " missing: " + implKey);
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
        }
        if (implementingClass != null) {
            try {
                Class<?> cls = Class.forName(implementingClass);
                cls = cls.asSubclass(pluginClass);
                return cls.newInstance();
            }
            catch (ClassCastException e3) {
                throw new IllegalStateException(classSimpleName + " implementation is not an instance of " + classSimpleName + ": " + implementingClass, e3);
            }
            catch (ClassNotFoundException e4) {
                throw new IllegalStateException(classSimpleName + " implementation class not found: " + implementingClass, e4);
            }
            catch (InstantiationException e5) {
                throw new IllegalStateException(classSimpleName + " implementation not able to be instantiated: " + implementingClass, e5);
            }
            catch (IllegalAccessException e6) {
                throw new IllegalStateException(classSimpleName + " implementation not able to be accessed: " + implementingClass, e6);
            }
        }
        return null;
    }

    public RxJavaSchedulersHook getSchedulersHook() {
        if (this.schedulersHook.get() == null) {
            Object impl2 = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaSchedulersHook.class, RxJavaPlugins.getSystemPropertiesSafe());
            if (impl2 == null) {
                this.schedulersHook.compareAndSet(null, RxJavaSchedulersHook.getDefaultInstance());
            } else {
                this.schedulersHook.compareAndSet(null, (RxJavaSchedulersHook)impl2);
            }
        }
        return this.schedulersHook.get();
    }

    public void registerSchedulersHook(RxJavaSchedulersHook impl2) {
        if (!this.schedulersHook.compareAndSet(null, impl2)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.schedulersHook.get());
        }
    }
}

