/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import java.util.Arrays;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.exceptions.OnCompletedFailedException;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.exceptions.UnsubscribeFailedException;
import rx.plugins.RxJavaHooks;
import rx.plugins.RxJavaPlugins;

public class SafeSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super T> actual;
    boolean done;

    public SafeSubscriber(Subscriber<? super T> actual) {
        super(actual);
        this.actual = actual;
    }

    @Override
    public void onCompleted() {
        if (!this.done) {
            this.done = true;
            try {
                this.actual.onCompleted();
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RxJavaHooks.onError(e2);
                throw new OnCompletedFailedException(e2.getMessage(), e2);
            }
            finally {
                try {
                    this.unsubscribe();
                }
                catch (Throwable e3) {
                    RxJavaHooks.onError(e3);
                    throw new UnsubscribeFailedException(e3.getMessage(), e3);
                }
            }
        }
    }

    @Override
    public void onError(Throwable e2) {
        Exceptions.throwIfFatal(e2);
        if (!this.done) {
            this.done = true;
            this._onError(e2);
        }
    }

    @Override
    public void onNext(T t3) {
        try {
            if (!this.done) {
                this.actual.onNext(t3);
            }
        }
        catch (Throwable e2) {
            Exceptions.throwOrReport(e2, this);
        }
    }

    protected void _onError(Throwable e2) {
        RxJavaPlugins.getInstance().getErrorHandler().handleError(e2);
        try {
            this.actual.onError(e2);
        }
        catch (OnErrorNotImplementedException e22) {
            try {
                this.unsubscribe();
            }
            catch (Throwable unsubscribeException) {
                RxJavaHooks.onError(unsubscribeException);
                throw new OnErrorNotImplementedException("Observer.onError not implemented and error while unsubscribing.", new CompositeException(Arrays.asList(e2, unsubscribeException)));
            }
            throw e22;
        }
        catch (Throwable e23) {
            RxJavaHooks.onError(e23);
            try {
                this.unsubscribe();
            }
            catch (Throwable unsubscribeException) {
                RxJavaHooks.onError(unsubscribeException);
                throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError and during unsubscription.", new CompositeException(Arrays.asList(e2, e23, unsubscribeException)));
            }
            throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError", new CompositeException(Arrays.asList(e2, e23)));
        }
        try {
            this.unsubscribe();
        }
        catch (Throwable unsubscribeException) {
            RxJavaHooks.onError(unsubscribeException);
            throw new OnErrorFailedException(unsubscribeException);
        }
    }

    public Subscriber<? super T> getActual() {
        return this.actual;
    }
}

