/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.annotations.Beta;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func3;
import rx.internal.operators.BufferUntilSubscriber;
import rx.observers.SerializedObserver;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.CompositeSubscription;

@Beta
public abstract class AsyncOnSubscribe<S, T>
implements Observable.OnSubscribe<T> {
    protected abstract S generateState();

    protected abstract S next(S var1, long var2, Observer<Observable<? extends T>> var4);

    protected void onUnsubscribe(S state) {
    }

    public static <S, T> AsyncOnSubscribe<S, T> createSingleState(Func0<? extends S> generator, final Action3<? super S, Long, ? super Observer<Observable<? extends T>>> next2) {
        Func3 nextFunc = new Func3<S, Long, Observer<Observable<? extends T>>, S>(){

            @Override
            public S call(S state, Long requested, Observer<Observable<? extends T>> subscriber) {
                next2.call(state, requested, subscriber);
                return state;
            }
        };
        return new AsyncOnSubscribeImpl(generator, nextFunc);
    }

    public static <S, T> AsyncOnSubscribe<S, T> createSingleState(Func0<? extends S> generator, final Action3<? super S, Long, ? super Observer<Observable<? extends T>>> next2, Action1<? super S> onUnsubscribe) {
        Func3 nextFunc = new Func3<S, Long, Observer<Observable<? extends T>>, S>(){

            @Override
            public S call(S state, Long requested, Observer<Observable<? extends T>> subscriber) {
                next2.call(state, requested, subscriber);
                return state;
            }
        };
        return new AsyncOnSubscribeImpl(generator, nextFunc, onUnsubscribe);
    }

    public static <S, T> AsyncOnSubscribe<S, T> createStateful(Func0<? extends S> generator, Func3<? super S, Long, ? super Observer<Observable<? extends T>>, ? extends S> next2, Action1<? super S> onUnsubscribe) {
        return new AsyncOnSubscribeImpl(generator, next2, onUnsubscribe);
    }

    public static <S, T> AsyncOnSubscribe<S, T> createStateful(Func0<? extends S> generator, Func3<? super S, Long, ? super Observer<Observable<? extends T>>, ? extends S> next2) {
        return new AsyncOnSubscribeImpl(generator, next2);
    }

    public static <T> AsyncOnSubscribe<Void, T> createStateless(final Action2<Long, ? super Observer<Observable<? extends T>>> next2) {
        Func3 nextFunc = new Func3<Void, Long, Observer<Observable<? extends T>>, Void>(){

            @Override
            public Void call(Void state, Long requested, Observer<Observable<? extends T>> subscriber) {
                next2.call(requested, subscriber);
                return state;
            }
        };
        return new AsyncOnSubscribeImpl(nextFunc);
    }

    public static <T> AsyncOnSubscribe<Void, T> createStateless(final Action2<Long, ? super Observer<Observable<? extends T>>> next2, final Action0 onUnsubscribe) {
        Func3 nextFunc = new Func3<Void, Long, Observer<Observable<? extends T>>, Void>(){

            @Override
            public Void call(Void state, Long requested, Observer<Observable<? extends T>> subscriber) {
                next2.call(requested, subscriber);
                return null;
            }
        };
        Action1<Void> wrappedOnUnsubscribe = new Action1<Void>(){

            @Override
            public void call(Void t3) {
                onUnsubscribe.call();
            }
        };
        return new AsyncOnSubscribeImpl(nextFunc, wrappedOnUnsubscribe);
    }

    @Override
    public final void call(final Subscriber<? super T> actualSubscriber) {
        S state;
        try {
            state = this.generateState();
        }
        catch (Throwable ex) {
            actualSubscriber.onError(ex);
            return;
        }
        UnicastSubject subject = UnicastSubject.create();
        final AsyncOuterManager outerProducer = new AsyncOuterManager(this, state, subject);
        Subscriber concatSubscriber = new Subscriber<T>(){

            @Override
            public void onNext(T t3) {
                actualSubscriber.onNext(t3);
            }

            @Override
            public void onError(Throwable e2) {
                actualSubscriber.onError(e2);
            }

            @Override
            public void onCompleted() {
                actualSubscriber.onCompleted();
            }

            @Override
            public void setProducer(Producer p) {
                outerProducer.setConcatProducer(p);
            }
        };
        subject.onBackpressureBuffer().concatMap(new Func1<Observable<T>, Observable<T>>(){

            @Override
            public Observable<T> call(Observable<T> v) {
                return v.onBackpressureBuffer();
            }
        }).unsafeSubscribe(concatSubscriber);
        actualSubscriber.add(concatSubscriber);
        actualSubscriber.add(outerProducer);
        actualSubscriber.setProducer(outerProducer);
    }

    static final class UnicastSubject<T>
    extends Observable<T>
    implements Observer<T> {
        private final State<T> state;

        public static <T> UnicastSubject<T> create() {
            return new UnicastSubject(new State());
        }

        protected UnicastSubject(State<T> state) {
            super(state);
            this.state = state;
        }

        @Override
        public void onCompleted() {
            this.state.subscriber.onCompleted();
        }

        @Override
        public void onError(Throwable e2) {
            this.state.subscriber.onError(e2);
        }

        @Override
        public void onNext(T t3) {
            this.state.subscriber.onNext(t3);
        }

        static final class State<T>
        implements Observable.OnSubscribe<T> {
            Subscriber<? super T> subscriber;

            State() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(Subscriber<? super T> s2) {
                State state = this;
                synchronized (state) {
                    if (this.subscriber == null) {
                        this.subscriber = s2;
                        return;
                    }
                }
                s2.onError(new IllegalStateException("There can be only one subscriber"));
            }
        }
    }

    static final class AsyncOuterManager<S, T>
    implements Producer,
    Subscription,
    Observer<Observable<? extends T>> {
        final AtomicBoolean isUnsubscribed;
        private final AsyncOnSubscribe<S, T> parent;
        private final SerializedObserver<Observable<? extends T>> serializedSubscriber;
        final CompositeSubscription subscriptions = new CompositeSubscription();
        private boolean hasTerminated;
        private boolean onNextCalled;
        private S state;
        private final UnicastSubject<Observable<T>> merger;
        boolean emitting;
        List<Long> requests;
        Producer concatProducer;
        long expectedDelivery;

        public AsyncOuterManager(AsyncOnSubscribe<S, T> parent, S initialState, UnicastSubject<Observable<T>> merger) {
            this.parent = parent;
            this.serializedSubscriber = new SerializedObserver(this);
            this.state = initialState;
            this.merger = merger;
            this.isUnsubscribed = new AtomicBoolean();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsubscribe() {
            if (this.isUnsubscribed.compareAndSet(false, true)) {
                AsyncOuterManager asyncOuterManager = this;
                synchronized (asyncOuterManager) {
                    if (this.emitting) {
                        this.requests = new ArrayList<Long>();
                        this.requests.add(0L);
                        return;
                    }
                    this.emitting = true;
                }
                this.cleanup();
            }
        }

        void setConcatProducer(Producer p) {
            if (this.concatProducer != null) {
                throw new IllegalStateException("setConcatProducer may be called at most once!");
            }
            this.concatProducer = p;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.isUnsubscribed.get();
        }

        public void nextIteration(long requestCount) {
            this.state = this.parent.next(this.state, requestCount, this.serializedSubscriber);
        }

        void cleanup() {
            this.subscriptions.unsubscribe();
            try {
                this.parent.onUnsubscribe(this.state);
            }
            catch (Throwable ex) {
                this.handleThrownError(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            if (n == 0L) {
                return;
            }
            if (n < 0L) {
                throw new IllegalStateException("Request can't be negative! " + n);
            }
            boolean quit = false;
            AsyncOuterManager asyncOuterManager = this;
            synchronized (asyncOuterManager) {
                if (this.emitting) {
                    List<Long> q = this.requests;
                    if (q == null) {
                        this.requests = q = new ArrayList<Long>();
                    }
                    q.add(n);
                    quit = true;
                } else {
                    this.emitting = true;
                }
            }
            this.concatProducer.request(n);
            if (quit) {
                return;
            }
            if (this.tryEmit(n)) {
                return;
            }
            block6: while (true) {
                long r;
                List<Long> q;
                Object object = this;
                synchronized (object) {
                    q = this.requests;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.requests = null;
                }
                object = q.iterator();
                do {
                    if (!object.hasNext()) continue block6;
                } while (!this.tryEmit(r = ((Long)object.next()).longValue()));
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRemaining(long n) {
            if (n == 0L) {
                return;
            }
            if (n < 0L) {
                throw new IllegalStateException("Request can't be negative! " + n);
            }
            AsyncOuterManager asyncOuterManager = this;
            synchronized (asyncOuterManager) {
                if (this.emitting) {
                    List<Long> q = this.requests;
                    if (q == null) {
                        this.requests = q = new ArrayList<Long>();
                    }
                    q.add(n);
                    return;
                }
                this.emitting = true;
            }
            if (this.tryEmit(n)) {
                return;
            }
            block6: while (true) {
                long r;
                List<Long> q;
                Object object = this;
                synchronized (object) {
                    q = this.requests;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.requests = null;
                }
                object = q.iterator();
                do {
                    if (!object.hasNext()) continue block6;
                } while (!this.tryEmit(r = ((Long)object.next()).longValue()));
                break;
            }
        }

        boolean tryEmit(long n) {
            if (this.isUnsubscribed()) {
                this.cleanup();
                return true;
            }
            try {
                this.onNextCalled = false;
                this.expectedDelivery = n;
                this.nextIteration(n);
                if (this.hasTerminated && !this.subscriptions.hasSubscriptions() || this.isUnsubscribed()) {
                    this.cleanup();
                    return true;
                }
                if (!this.onNextCalled) {
                    this.handleThrownError(new IllegalStateException("No events emitted!"));
                    return true;
                }
            }
            catch (Throwable ex) {
                this.handleThrownError(ex);
                return true;
            }
            return false;
        }

        private void handleThrownError(Throwable ex) {
            if (this.hasTerminated) {
                RxJavaHooks.onError(ex);
            } else {
                this.hasTerminated = true;
                this.merger.onError(ex);
                this.cleanup();
            }
        }

        @Override
        public void onCompleted() {
            if (this.hasTerminated) {
                throw new IllegalStateException("Terminal event already emitted.");
            }
            this.hasTerminated = true;
            this.merger.onCompleted();
        }

        @Override
        public void onError(Throwable e2) {
            if (this.hasTerminated) {
                throw new IllegalStateException("Terminal event already emitted.");
            }
            this.hasTerminated = true;
            this.merger.onError(e2);
        }

        @Override
        public void onNext(Observable<? extends T> t3) {
            if (this.onNextCalled) {
                throw new IllegalStateException("onNext called multiple times!");
            }
            this.onNextCalled = true;
            if (this.hasTerminated) {
                return;
            }
            this.subscribeBufferToObservable(t3);
        }

        private void subscribeBufferToObservable(Observable<? extends T> t3) {
            final BufferUntilSubscriber buffer = BufferUntilSubscriber.create();
            final long expected = this.expectedDelivery;
            final Subscriber s2 = new Subscriber<T>(){
                long remaining;
                {
                    this.remaining = expected;
                }

                @Override
                public void onNext(T t3) {
                    --this.remaining;
                    buffer.onNext(t3);
                }

                @Override
                public void onError(Throwable e2) {
                    buffer.onError(e2);
                }

                @Override
                public void onCompleted() {
                    buffer.onCompleted();
                    long r = this.remaining;
                    if (r > 0L) {
                        AsyncOuterManager.this.requestRemaining(r);
                    }
                }
            };
            this.subscriptions.add(s2);
            Observable<T> doOnTerminate = t3.doOnTerminate(new Action0(){

                @Override
                public void call() {
                    AsyncOuterManager.this.subscriptions.remove(s2);
                }
            });
            doOnTerminate.subscribe(s2);
            this.merger.onNext(buffer);
        }
    }

    static final class AsyncOnSubscribeImpl<S, T>
    extends AsyncOnSubscribe<S, T> {
        private final Func0<? extends S> generator;
        private final Func3<? super S, Long, ? super Observer<Observable<? extends T>>, ? extends S> next;
        private final Action1<? super S> onUnsubscribe;

        AsyncOnSubscribeImpl(Func0<? extends S> generator, Func3<? super S, Long, ? super Observer<Observable<? extends T>>, ? extends S> next2, Action1<? super S> onUnsubscribe) {
            this.generator = generator;
            this.next = next2;
            this.onUnsubscribe = onUnsubscribe;
        }

        public AsyncOnSubscribeImpl(Func0<? extends S> generator, Func3<? super S, Long, ? super Observer<Observable<? extends T>>, ? extends S> next2) {
            this(generator, next2, null);
        }

        public AsyncOnSubscribeImpl(Func3<S, Long, Observer<Observable<? extends T>>, S> next2, Action1<? super S> onUnsubscribe) {
            this(null, next2, onUnsubscribe);
        }

        public AsyncOnSubscribeImpl(Func3<S, Long, Observer<Observable<? extends T>>, S> nextFunc) {
            this(null, nextFunc, null);
        }

        @Override
        protected S generateState() {
            return this.generator == null ? null : (S)this.generator.call();
        }

        @Override
        protected S next(S state, long requested, Observer<Observable<? extends T>> observer) {
            return this.next.call(state, requested, observer);
        }

        @Override
        protected void onUnsubscribe(S state) {
            if (this.onUnsubscribe != null) {
                this.onUnsubscribe.call(state);
            }
        }
    }
}

